/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.NewTagEntity;
import io.gravitee.rest.api.model.TagEntity;
import io.gravitee.rest.api.model.TagReferenceType;
import io.gravitee.rest.api.model.UpdateTagEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.GraviteeLicenseFeature;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.stream.Collectors;

@Tag(name="Sharding Tags")
public class TagsResource
extends AbstractResource {
    @Inject
    private TagService tagService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List sharding tags")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of sharding tags", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TagEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<TagEntity> getTags() {
        return this.tagService.findByReference(GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION).stream().sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName())).collect(Collectors.toList());
    }

    @GET
    @Path(value="{tag}")
    @Produces(value={"application/json"})
    @Operation(summary="Get a sharding tag", description="User must have the MANAGEMENT_TAG[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Tag", content={@Content(mediaType="application/json", schema=@Schema(implementation=TagEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TAG, acls={RolePermissionAction.READ}), @Permission(value=RolePermission.ORGANIZATION_TAG, acls={RolePermissionAction.READ})})
    public TagEntity getTag(@PathParam(value="tag") String tag) {
        return this.tagService.findByIdAndReference(tag, GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a sharding tag", description="User must have the MANAGEMENT_TAG[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="A new sharding tag", content={@Content(mediaType="application/json", schema=@Schema(implementation=TagEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TAG, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ORGANIZATION_TAG, acls={RolePermissionAction.CREATE})})
    @GraviteeLicenseFeature(value="apim-sharding-tags")
    public TagEntity createTag(@Valid @NotNull NewTagEntity tag) {
        return this.tagService.create(GraviteeContext.getExecutionContext(), tag, GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION);
    }

    @PUT
    @Path(value="{tag}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an existing sharding tag", description="User must have the MANAGEMENT_TAG[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Sharding tag", content={@Content(mediaType="application/json", schema=@Schema(implementation=TagEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TAG, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.ORGANIZATION_TAG, acls={RolePermissionAction.UPDATE})})
    @GraviteeLicenseFeature(value="apim-sharding-tags")
    public TagEntity updateTag(@PathParam(value="tag") String tagId, @Valid @NotNull UpdateTagEntity tag) {
        return this.tagService.update(GraviteeContext.getExecutionContext(), tag, GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION);
    }

    @Path(value="{tag}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete an existing sharding tag", description="User must have the MANAGEMENT_TAG[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Sharding tag successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_TAG, acls={RolePermissionAction.DELETE}), @Permission(value=RolePermission.ORGANIZATION_TAG, acls={RolePermissionAction.DELETE})})
    @GraviteeLicenseFeature(value="apim-sharding-tags")
    public void deleteTag(@PathParam(value="tag") String tag) {
        this.tagService.delete(GraviteeContext.getExecutionContext(), tag, GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION);
    }
}

