/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.monitoring.MonitoringData;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.MonitoringService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;

@Tag(name="Gateway")
public class MonitoringResource
extends AbstractResource {
    @Inject
    private MonitoringService monitoringService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get monitoring metrics for a gateway instance")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public MonitoringData getInstanceMonitoring(@PathParam(value="gatewayId") String gatewayId) {
        return this.monitoringService.findMonitoring(gatewayId);
    }
}

