/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.apim.core.subscription.use_case.CloseSubscriptionUseCase;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscriptionApiKeysResource;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.ProcessSubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionConsumerStatus;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.TransferSubscriptionEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanMode;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.sql.Date;

@Tag(name="API Subscriptions")
public class ApiSubscriptionResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private CloseSubscriptionUseCase closeSubscriptionUsecase;
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private PlanSearchService planSearchService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private UserService userService;
    @Inject
    private ParameterService parameterService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a subscription", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Get a subscription", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="404", description="Subscription does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public Subscription getApiSubscription(@PathParam(value="subscription") String subscription) {
        return this.convert(GraviteeContext.getExecutionContext(), this.subscriptionService.findById(subscription));
    }

    @POST
    @Path(value="/_process")
    @Produces(value={"application/json"})
    @Operation(summary="Update a subscription", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Update a subscription", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="Bad subscription format"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response processApiSubscription(@PathParam(value="subscription") String subscription, @Parameter(name="subscription", required=true) @Valid @NotNull ProcessSubscriptionEntity processSubscriptionEntity) {
        if (processSubscriptionEntity.getId() != null && !subscription.equals(processSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to process").build();
        }
        processSubscriptionEntity.setId(subscription);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        io.gravitee.rest.api.model.SubscriptionEntity subscriptionEntity = this.subscriptionService.process(executionContext, processSubscriptionEntity, this.getAuthenticatedUser());
        return Response.ok((Object)this.convert(executionContext, subscriptionEntity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a subscription", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Update a subscription", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="Bad subscription format"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiSubscription(@PathParam(value="subscription") String subscription, @Parameter(name="subscription", required=true) @Valid @NotNull UpdateSubscriptionEntity updateSubscriptionEntity) {
        if (updateSubscriptionEntity.getId() != null && !subscription.equals(updateSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to update").build();
        }
        updateSubscriptionEntity.setId(subscription);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        io.gravitee.rest.api.model.SubscriptionEntity subscriptionEntity = this.subscriptionService.update(executionContext, updateSubscriptionEntity);
        return Response.ok((Object)this.convert(executionContext, subscriptionEntity)).build();
    }

    @POST
    @Path(value="/status")
    @Produces(value={"application/json"})
    @Operation(summary="Change the status of a subscription", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Subscription status successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="Status changes not authorized"), @ApiResponse(responseCode="404", description="API subscription does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response changeApiSubscriptionStatus(@PathParam(value="subscription") String subscription, @Parameter(required=true, schema=@Schema(allowableValues={"CLOSED", "PAUSED", "RESUMED"})) @QueryParam(value="status") SubscriptionStatus subscriptionStatus) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        UserDetails user = this.getAuthenticatedUserDetails();
        if (SubscriptionStatus.CLOSED.equals((Object)subscriptionStatus)) {
            CloseSubscriptionUseCase.Output result = this.closeSubscriptionUsecase.execute(CloseSubscriptionUseCase.Input.builder().subscriptionId(subscription).apiId(this.api).auditInfo(AuditInfo.builder().organizationId(executionContext.getOrganizationId()).environmentId(executionContext.getEnvironmentId()).actor(AuditActor.builder().userId(user.getUsername()).userSource(user.getSource()).userSourceId(user.getSourceId()).build()).build()).build());
            return Response.ok((Object)this.convert(executionContext, result.subscription())).build();
        }
        if (SubscriptionStatus.PAUSED.equals((Object)subscriptionStatus)) {
            io.gravitee.rest.api.model.SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.pause(executionContext, subscription);
            return Response.ok((Object)this.convert(executionContext, updatedSubscriptionEntity)).build();
        }
        if (SubscriptionStatus.RESUMED.equals((Object)subscriptionStatus)) {
            io.gravitee.rest.api.model.SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.resume(executionContext, subscription);
            return Response.ok((Object)this.convert(executionContext, updatedSubscriptionEntity)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @POST
    @Path(value="/_transfer")
    @Produces(value={"application/json"})
    @Operation(summary="Transfer a subscription", description="User must have the API_SUBSCRIPTION update permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Update a subscription", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="Bad subscription format"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response transferApiSubscription(@PathParam(value="subscription") String subscription, @Parameter(name="subscription", required=true) @Valid @NotNull TransferSubscriptionEntity transferSubscriptionEntity) {
        if (transferSubscriptionEntity.getId() != null && !subscription.equals(transferSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to process").build();
        }
        transferSubscriptionEntity.setId(subscription);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        io.gravitee.rest.api.model.SubscriptionEntity subscriptionEntity = this.subscriptionService.transfer(executionContext, transferSubscriptionEntity, this.getAuthenticatedUser());
        return Response.ok((Object)this.convert(executionContext, subscriptionEntity)).build();
    }

    @Path(value="apikeys")
    public ApiSubscriptionApiKeysResource getApiSubscriptionApiKeysResourceResource() {
        return (ApiSubscriptionApiKeysResource)this.resourceContext.getResource(ApiSubscriptionApiKeysResource.class);
    }

    private Subscription convert(ExecutionContext executionContext, io.gravitee.rest.api.model.SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setConsumerStatus(subscriptionEntity.getConsumerStatus());
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(executionContext, subscriptionEntity.getSubscribedBy(), true).getDisplayName()));
        subscription.setClientId(subscriptionEntity.getClientId());
        subscription.setMetadata(subscriptionEntity.getMetadata());
        subscription.setPlan(this.fetchPlan(executionContext, subscriptionEntity.getPlan()));
        subscription.setApplication(this.fetchApplication(executionContext, subscriptionEntity.getApplication()));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        subscription.setPausedAt(subscriptionEntity.getPausedAt());
        subscription.setConsumerPausedAt(subscriptionEntity.getConsumerPausedAt());
        return subscription;
    }

    private Subscription convert(ExecutionContext executionContext, SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(Date.from(subscriptionEntity.getCreatedAt().toInstant()));
        subscription.setUpdatedAt(Date.from(subscriptionEntity.getUpdatedAt().toInstant()));
        subscription.setStartingAt(subscriptionEntity.getStartingAt() != null ? Date.from(subscriptionEntity.getStartingAt().toInstant()) : null);
        subscription.setEndingAt(subscriptionEntity.getEndingAt() != null ? Date.from(subscriptionEntity.getEndingAt().toInstant()) : null);
        subscription.setClosedAt(subscriptionEntity.getClosedAt() != null ? Date.from(subscriptionEntity.getClosedAt().toInstant()) : null);
        subscription.setPausedAt(subscriptionEntity.getPausedAt() != null ? Date.from(subscriptionEntity.getPausedAt().toInstant()) : null);
        subscription.setConsumerPausedAt(subscriptionEntity.getConsumerPausedAt() != null ? Date.from(subscriptionEntity.getConsumerPausedAt().toInstant()) : null);
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt() != null ? Date.from(subscriptionEntity.getProcessedAt().toInstant()) : null);
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setRequest(subscriptionEntity.getRequestMessage());
        subscription.setReason(subscriptionEntity.getReasonMessage());
        subscription.setStatus(switch (subscriptionEntity.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case SubscriptionEntity.Status.PENDING -> SubscriptionStatus.PENDING;
            case SubscriptionEntity.Status.REJECTED -> SubscriptionStatus.REJECTED;
            case SubscriptionEntity.Status.ACCEPTED -> SubscriptionStatus.ACCEPTED;
            case SubscriptionEntity.Status.CLOSED -> SubscriptionStatus.CLOSED;
            case SubscriptionEntity.Status.PAUSED -> SubscriptionStatus.PAUSED;
        });
        subscription.setConsumerStatus(switch (subscriptionEntity.getConsumerStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case SubscriptionEntity.ConsumerStatus.STARTED -> SubscriptionConsumerStatus.STARTED;
            case SubscriptionEntity.ConsumerStatus.STOPPED -> SubscriptionConsumerStatus.STOPPED;
            case SubscriptionEntity.ConsumerStatus.FAILURE -> SubscriptionConsumerStatus.FAILURE;
        });
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(executionContext, subscriptionEntity.getSubscribedBy(), true).getDisplayName()));
        subscription.setClientId(subscriptionEntity.getClientId());
        subscription.setMetadata(subscriptionEntity.getMetadata());
        subscription.setPlan(this.fetchPlan(executionContext, subscriptionEntity.getPlanId()));
        subscription.setApplication(this.fetchApplication(executionContext, subscriptionEntity.getApplicationId()));
        return subscription;
    }

    private Subscription.Plan fetchPlan(ExecutionContext executionContext, String planId) {
        GenericPlanEntity genericPlan = this.planSearchService.findById(executionContext, planId);
        Subscription.Plan plan = new Subscription.Plan(genericPlan.getId(), genericPlan.getName());
        if (genericPlan.getPlanMode() == PlanMode.STANDARD) {
            plan.setSecurity(genericPlan.getPlanSecurity().getType());
        }
        return plan;
    }

    private Subscription.Application fetchApplication(ExecutionContext executionContext, String applicationId) {
        ApplicationEntity application = this.applicationService.findById(executionContext, applicationId);
        return new Subscription.Application(application.getId(), application.getName(), application.getType(), application.getDescription(), application.getDomain(), new Subscription.User(application.getPrimaryOwner().getId(), application.getPrimaryOwner().getDisplayName()), application.getApiKeyMode());
    }
}

