/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractApiKeyResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscriptionApiKeyResource;
import io.gravitee.rest.api.model.ApiKeyEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.rest.annotation.Permission;
import io.gravitee.rest.api.rest.annotation.Permissions;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import io.gravitee.rest.api.validator.CustomApiKey;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Tag(name="API Keys")
public class ApiSubscriptionApiKeysResource
extends AbstractApiKeyResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private ParameterService parameterService;
    @Inject
    private SubscriptionService subscriptionService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;
    @PathParam(value="subscription")
    @Parameter(name="subscription")
    private String subscription;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List all API Keys for a subscription", description="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of API Keys for a subscription", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApiKeyEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public List<ApiKeyEntity> getApiKeysForApiSubscription() {
        return this.apiKeyService.findBySubscription(GraviteeContext.getExecutionContext(), this.subscription);
    }

    @POST
    @Path(value="/_renew")
    @Produces(value={"application/json"})
    @Operation(summary="Renew an API Key", description="User must have the MANAGE_API_KEYS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="A new API Key", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiKeyEntity.class))}), @ApiResponse(responseCode="400", description="Bad custom API Key format or custom API Key definition disabled"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response renewSubscriptionApiKeysForApiSubscription(@Parameter(name="customApiKey") @CustomApiKey @QueryParam(value="customApiKey") String customApiKey) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (StringUtils.isNotEmpty((CharSequence)customApiKey) && !this.parameterService.findAsBoolean(executionContext, Key.PLAN_SECURITY_APIKEY_CUSTOM_ALLOWED, ParameterReferenceType.ENVIRONMENT)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"You are not allowed to provide a custom API Key").build();
        }
        SubscriptionEntity subscriptionEntity = this.subscriptionService.findById(this.subscription);
        if (subscriptionEntity == null) {
            throw new SubscriptionNotFoundException(this.subscription);
        }
        this.checkApplicationDoesntUseSharedApiKey(executionContext, subscriptionEntity.getApplication());
        ApiKeyEntity apiKeyEntity = this.apiKeyService.renew(executionContext, subscriptionEntity, customApiKey);
        URI location = URI.create(this.uriInfo.getPath().replace("_renew", apiKeyEntity.getId()));
        return Response.created((URI)location).entity((Object)apiKeyEntity).build();
    }

    @Path(value="{apikey}")
    public ApiSubscriptionApiKeyResource getApiSubscriptionApiKeyResource() {
        return (ApiSubscriptionApiKeyResource)this.resourceContext.getResource(ApiSubscriptionApiKeyResource.class);
    }
}

