/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import io.gravitee.common.util.Maps;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.model.Group;
import io.gravitee.rest.api.exception.InvalidImageException;
import io.gravitee.rest.api.idp.api.authentication.UserDetailRole;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.model.TokenEntity;
import io.gravitee.rest.api.management.rest.model.TokenType;
import io.gravitee.rest.api.management.rest.model.wrapper.TaskEntityPagedResult;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.TokensResource;
import io.gravitee.rest.api.management.rest.resource.organization.NewsletterResource;
import io.gravitee.rest.api.management.rest.resource.organization.UserNotificationsResource;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.TagReferenceType;
import io.gravitee.rest.api.model.UpdateUserEntity;
import io.gravitee.rest.api.model.UrlPictureEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.security.cookies.CookieGenerator;
import io.gravitee.rest.api.security.utils.ImageUtils;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.TaskService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Tag(name="Current User")
public class CurrentUserResource
extends AbstractResource {
    public static final String IDP_SOURCE_MEMORY = "memory";
    private static Logger LOG = LoggerFactory.getLogger(CurrentUserResource.class);
    @Inject
    private UserService userService;
    @Context
    private HttpServletResponse response;
    @Inject
    private TaskService taskService;
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ConfigurableEnvironment environment;
    @Inject
    private CookieGenerator cookieGenerator;
    @Inject
    private TagService tagService;
    @Inject
    private EnvironmentService environmentService;
    @Inject
    private GroupRepository groupRepository;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get the authenticated user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Authenticated user", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserDetails.class))}), @ApiResponse(responseCode="401", description="Unauthorized user"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getCurrentUser() {
        if (this.isAuthenticated()) {
            UserEntity userEntity;
            UserDetails details = this.getAuthenticatedUserDetails();
            String userId = details.getUsername();
            String password = details.getPassword() != null ? details.getPassword() : "";
            try {
                userEntity = this.userService.findByIdWithRoles(GraviteeContext.getExecutionContext(), userId);
            }
            catch (UserNotFoundException unfe) {
                String unfeMessage = "User '{}' does not exist.";
                if (LOG.isDebugEnabled()) {
                    LOG.info("User '{}' does not exist.", (Object)userId, (Object)unfe);
                } else {
                    LOG.info("User '{}' does not exist.", (Object)userId);
                }
                this.response.addCookie(this.cookieGenerator.generate("Auth-Graviteeio-APIM", null));
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            ArrayList authorities = new ArrayList(details.getAuthorities());
            UserDetails userDetails = new UserDetails(userEntity.getId(), password, authorities);
            userDetails.setId(userEntity.getId());
            userDetails.setFirstname(IDP_SOURCE_MEMORY.equals(userEntity.getSource()) && userEntity.getFirstname() != null ? userEntity.getFirstname() : details.getFirstname());
            userDetails.setLastname(IDP_SOURCE_MEMORY.equals(userEntity.getSource()) && userEntity.getLastname() != null ? userEntity.getLastname() : details.getLastname());
            userDetails.setSource(userEntity.getSource());
            userDetails.setSourceId(userEntity.getSourceId());
            userDetails.setPrimaryOwner(userEntity.isPrimaryOwner());
            userDetails.setCreatedAt(userEntity.getCreatedAt());
            userDetails.setUpdatedAt(userEntity.getUpdatedAt());
            userDetails.setLastConnectionAt(userEntity.getLastConnectionAt());
            userDetails.setOrganizationId(userEntity.getOrganizationId());
            if (details.getEmail() == null && IDP_SOURCE_MEMORY.equals(userEntity.getSource()) && userEntity.getEmail() != null) {
                userDetails.setEmail(userEntity.getEmail());
            } else {
                userDetails.setEmail(details.getEmail());
            }
            boolean newsletterEnabled = (Boolean)this.environment.getProperty("newsletter.enabled", Boolean.TYPE, (Object)true);
            if (newsletterEnabled && userEntity.getNewsletterSubscribed() == null && userEntity.getFirstConnectionAt() != null) {
                long diffInMs = Math.abs(new Date().getTime() - userEntity.getFirstConnectionAt().getTime());
                long diff = TimeUnit.DAYS.convert(diffInMs, TimeUnit.MILLISECONDS);
                userDetails.setDisplayNewsletterSubscription(diff >= 7L);
            } else {
                userDetails.setDisplayNewsletterSubscription(false);
            }
            userDetails.setRoles(userEntity.getRoles().stream().map(userEntityRole -> {
                UserDetailRole userDetailRole = new UserDetailRole();
                userDetailRole.setScope(userEntityRole.getScope().name());
                userDetailRole.setName(userEntityRole.getName());
                userDetailRole.setPermissions(userEntityRole.getPermissions());
                return userDetailRole;
            }).collect(Collectors.toList()));
            Set memberships = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP);
            if (!memberships.isEmpty()) {
                HashMap userGroups = new HashMap();
                this.environmentService.findByOrganization(GraviteeContext.getCurrentOrganization()).forEach(environment -> {
                    try {
                        Set groups = this.groupRepository.findAllByEnvironment(environment.getId());
                        userGroups.put(environment.getId(), new HashSet());
                        memberships.stream().map(MembershipEntity::getReferenceId).forEach(groupId -> {
                            Optional<Group> optionalGroup = groups.stream().filter(group -> groupId.equals(group.getId())).findFirst();
                            optionalGroup.ifPresent(entity -> ((Set)userGroups.get(environment.getId())).add(entity.getName()));
                        });
                        userDetails.setGroupsByEnvironment(userGroups);
                    }
                    catch (TechnicalException e) {
                        LOG.error("Error while trying to get groups of the user " + userId, (Throwable)e);
                    }
                });
            }
            userDetails.setFirstLogin(1L == userEntity.getLoginCount());
            if (userEntity.getCustomFields() != null) {
                userDetails.setCustomFields(userEntity.getCustomFields());
            }
            return Response.ok((Object)userDetails, (String)"application/json").build();
        }
        return Response.ok().build();
    }

    @DELETE
    @Operation(summary="Delete the current logged user")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Current user successfully deleted"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteCurrentUser() {
        if (this.isAuthenticated()) {
            this.userService.delete(GraviteeContext.getExecutionContext(), this.getAuthenticatedUser());
            this.logoutCurrentUser();
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Operation(summary="Update the authenticated user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated user", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserEntity.class))}), @ApiResponse(responseCode="400", description="Invalid user profile"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateCurrentUser(@Valid @NotNull UpdateUserEntity user) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        UserEntity userEntity = this.userService.findById(executionContext, this.getAuthenticatedUser());
        try {
            if (user.getPicture() != null) {
                user.setPicture(ImageUtils.verifyAndRescale((String)user.getPicture()).toBase64());
            } else {
                user.setPicture(userEntity.getPicture());
            }
        }
        catch (InvalidImageException e) {
            LOG.warn("Invalid image format", (Throwable)e);
            throw new BadRequestException("Invalid image format : " + e.getMessage());
        }
        return Response.ok((Object)this.userService.update(executionContext, userEntity.getId(), user)).build();
    }

    @GET
    @Path(value="avatar")
    @Operation(summary="Get user's avatar")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User's avatar", content={@Content(mediaType="*/*", schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getCurrentUserPicture(@Context Request request) {
        String userId;
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        PictureEntity picture = this.userService.getPicture(executionContext, userId = this.userService.findById(executionContext, this.getAuthenticatedUser()).getId());
        if (picture instanceof UrlPictureEntity) {
            return Response.temporaryRedirect((URI)URI.create(((UrlPictureEntity)picture).getUrl())).build();
        }
        InlinePictureEntity image = (InlinePictureEntity)picture;
        if (image == null || image.getContent() == null) {
            return Response.ok().build();
        }
        EntityTag etag = new EntityTag(Integer.toString(new String(image.getContent()).hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.build();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(image.getContent(), 0, image.getContent().length);
        return Response.ok().entity((Object)baos).tag(etag).type(image.getType()).build();
    }

    @POST
    @Path(value="/login")
    @Operation(summary="Login")
    @Produces(value={"application/json"})
    public Response login(@Context HttpHeaders headers, @Context HttpServletResponse servletResponse) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal() instanceof UserDetails) {
            HashMap<String, String> claims = new HashMap<String, String>();
            claims.put("iss", this.environment.getProperty("jwt.issuer", "gravitee-management-auth"));
            UserDetails userDetails = (UserDetails)authentication.getPrincipal();
            List authorities = userDetails.getAuthorities().stream().map(authority -> Maps.builder().put((Object)"authority", (Object)authority.getAuthority()).build()).collect(Collectors.toList());
            Set roles = this.membershipService.getRoles(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization(), MembershipMemberType.USER, userDetails.getUsername());
            if (!roles.isEmpty()) {
                roles.forEach(role -> authorities.add(Maps.builder().put((Object)"authority", (Object)(role.getScope().toString() + ":" + role.getName())).build()));
            }
            this.environmentService.findByOrganization(GraviteeContext.getCurrentOrganization()).stream().flatMap(env -> this.membershipService.getRoles(MembershipReferenceType.ENVIRONMENT, env.getId(), MembershipMemberType.USER, userDetails.getUsername()).stream()).filter(Objects::nonNull).forEach(role -> authorities.add(Maps.builder().put((Object)"authority", (Object)(role.getScope().toString() + ":" + role.getName())).build()));
            Algorithm algorithm = Algorithm.HMAC256((String)this.environment.getProperty("jwt.secret"));
            Date issueAt = new Date();
            Instant expireAt = issueAt.toInstant().plus(Duration.ofSeconds(((Integer)this.environment.getProperty("jwt.expire-after", Integer.class, (Object)604800)).intValue()));
            String token = JWT.create().withIssuer(this.environment.getProperty("jwt.issuer", "gravitee-management-auth")).withIssuedAt(issueAt).withExpiresAt(Date.from(expireAt)).withSubject(userDetails.getUsername()).withClaim("permissions", authorities).withClaim("email", userDetails.getEmail()).withClaim("firstname", userDetails.getFirstname()).withClaim("lastname", userDetails.getLastname()).withClaim("org", userDetails.getOrganizationId()).withJWTId(UUID.randomUUID().toString()).sign(algorithm);
            TokenEntity tokenEntity = new TokenEntity();
            tokenEntity.setType(TokenType.BEARER);
            tokenEntity.setToken(token);
            Cookie bearerCookie = this.cookieGenerator.generate("Auth-Graviteeio-APIM", "Bearer%20" + token);
            servletResponse.addCookie(bearerCookie);
            return Response.ok((Object)tokenEntity).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Path(value="/logout")
    @Operation(summary="Logout")
    public Response logoutCurrentUser() {
        this.response.addCookie(this.cookieGenerator.generate("Auth-Graviteeio-APIM", null));
        return Response.ok().build();
    }

    @GET
    @Path(value="/tasks")
    @Produces(value={"application/json"})
    @Operation(summary="Get the user's tasks")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User's tasks", content={@Content(mediaType="application/json", schema=@Schema(implementation=TaskEntityPagedResult.class))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public TaskEntityPagedResult getUserTasks() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        List tasks = this.taskService.findAll(executionContext, this.getAuthenticatedUserOrNull());
        Map metadata = this.taskService.getMetadata(executionContext, tasks).toMap();
        TaskEntityPagedResult pagedResult = new TaskEntityPagedResult(tasks);
        pagedResult.setMetadata(metadata);
        return pagedResult;
    }

    @GET
    @Path(value="/tags")
    @Operation(summary="Get the user's allowed sharding tags")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User's sharding tags", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=String.class), uniqueItems=true))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Produces(value={"application/json"})
    public Response getUserShardingTags() {
        return Response.ok((Object)this.tagService.findByUser(this.getAuthenticatedUser(), GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION)).build();
    }

    @Path(value="/notifications")
    public UserNotificationsResource getUserNotificationsResource() {
        return (UserNotificationsResource)this.resourceContext.getResource(UserNotificationsResource.class);
    }

    @Path(value="/tokens")
    public TokensResource getTokensResource() {
        return (TokensResource)this.resourceContext.getResource(TokensResource.class);
    }

    @Path(value="/newsletter")
    public NewsletterResource getNewsletterResource() {
        return (NewsletterResource)this.resourceContext.getResource(NewsletterResource.class);
    }
}

