/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.AuditResource;
import io.gravitee.rest.api.management.rest.resource.EnvironmentsResource;
import io.gravitee.rest.api.management.rest.resource.PromotionsResource;
import io.gravitee.rest.api.management.rest.resource.auth.OAuth2AuthenticationResource;
import io.gravitee.rest.api.management.rest.resource.installation.InstallationResource;
import io.gravitee.rest.api.management.rest.resource.organization.ConsoleResource;
import io.gravitee.rest.api.management.rest.resource.organization.ConsoleSettingsResource;
import io.gravitee.rest.api.management.rest.resource.organization.CurrentUserResource;
import io.gravitee.rest.api.management.rest.resource.organization.OrganizationConfigurationResource;
import io.gravitee.rest.api.management.rest.resource.organization.OrganizationGroupsResource;
import io.gravitee.rest.api.management.rest.resource.organization.UsersResource;
import io.gravitee.rest.api.management.rest.resource.portal.SocialIdentityProvidersResource;
import io.gravitee.rest.api.management.rest.resource.search.SearchResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.UpdateOrganizationEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import java.util.stream.Collectors;

public class OrganizationResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private IdentityProviderService identityProviderService;
    @Inject
    private IdentityProviderActivationService identityProviderActivationService;
    @Inject
    private OrganizationService organizationService;

    @GET
    @Path(value="/identities")
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER_ACTIVATION, acls={RolePermissionAction.READ})})
    @Operation(summary="Get the list of identity provider activations for current organization", description="User must have the ORGANIZATION_IDENTITY_PROVIDER_ACTIVATION[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List identity provider activations for current organization", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=IdentityProviderActivationEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Set<IdentityProviderActivationEntity> listIdentityProviderActivations() {
        return this.identityProviderActivationService.findAllByTarget(new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getCurrentOrganization(), IdentityProviderActivationReferenceType.ORGANIZATION));
    }

    @PUT
    @Path(value="/identities")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER_ACTIVATION, acls={RolePermissionAction.CREATE, RolePermissionAction.DELETE, RolePermissionAction.UPDATE})})
    @Operation(summary="Update available organization identities", tags={"Organization"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Organization successfully updated"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateOrganizationIdentities(Set<IdentityProviderActivationEntity> identityProviderActivations) {
        this.identityProviderActivationService.updateTargetIdp(GraviteeContext.getExecutionContext(), new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getCurrentOrganization(), IdentityProviderActivationReferenceType.ORGANIZATION), identityProviderActivations.stream().filter(ipa -> {
            IdentityProviderEntity idp = this.identityProviderService.findById(ipa.getIdentityProvider());
            return GraviteeContext.getCurrentOrganization().equals(idp.getOrganization());
        }).map(IdentityProviderActivationEntity::getIdentityProvider).collect(Collectors.toList()));
        return Response.noContent().build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_POLICIES, acls={RolePermissionAction.CREATE, RolePermissionAction.DELETE, RolePermissionAction.UPDATE})})
    @Operation(summary="Update organization", tags={"Organization"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Organization successfully updated"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response update(UpdateOrganizationEntity organizationEntity) {
        OrganizationEntity updatedOrganization = this.organizationService.updateOrganizationAndFlows(GraviteeContext.getExecutionContext(), GraviteeContext.getCurrentOrganization(), organizationEntity);
        return Response.ok((Object)updatedOrganization).status(204).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_POLICIES, acls={RolePermissionAction.CREATE, RolePermissionAction.DELETE, RolePermissionAction.UPDATE})})
    @Operation(summary="GET organization", tags={"Organization"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Organization", content={@Content(mediaType="application/json", schema=@Schema(implementation=OrganizationEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response get() {
        return Response.ok((Object)this.organizationService.findById(GraviteeContext.getCurrentOrganization())).build();
    }

    @Path(value="auth/oauth2/{identity}")
    public OAuth2AuthenticationResource getOAuth2AuthenticationResource() {
        return (OAuth2AuthenticationResource)this.resourceContext.getResource(OAuth2AuthenticationResource.class);
    }

    @Path(value="configuration")
    public OrganizationConfigurationResource getConfigurationResource() {
        return (OrganizationConfigurationResource)this.resourceContext.getResource(OrganizationConfigurationResource.class);
    }

    @Path(value="console")
    public ConsoleResource getConsoleResource() {
        return (ConsoleResource)this.resourceContext.getResource(ConsoleResource.class);
    }

    @Path(value="environments")
    public EnvironmentsResource getEnvironmentsResource() {
        return (EnvironmentsResource)this.resourceContext.getResource(EnvironmentsResource.class);
    }

    @Path(value="social-identities")
    public SocialIdentityProvidersResource getSocialIdentityProvidersResource() {
        return (SocialIdentityProvidersResource)this.resourceContext.getResource(SocialIdentityProvidersResource.class);
    }

    @Path(value="search")
    public SearchResource getSearchResource() {
        return (SearchResource)this.resourceContext.getResource(SearchResource.class);
    }

    @Path(value="settings")
    public ConsoleSettingsResource getConsoleSettingsResource() {
        return (ConsoleSettingsResource)this.resourceContext.getResource(ConsoleSettingsResource.class);
    }

    @Path(value="users")
    public UsersResource getUsersResource() {
        return (UsersResource)this.resourceContext.getResource(UsersResource.class);
    }

    @Path(value="user")
    public CurrentUserResource getCurrentUserResource() {
        return (CurrentUserResource)this.resourceContext.getResource(CurrentUserResource.class);
    }

    @Path(value="installation")
    public InstallationResource getInstallationResource() {
        return (InstallationResource)this.resourceContext.getResource(InstallationResource.class);
    }

    @Path(value="groups")
    public OrganizationGroupsResource getGroupsResource() {
        return (OrganizationGroupsResource)this.resourceContext.getResource(OrganizationGroupsResource.class);
    }

    @Path(value="promotions")
    public PromotionsResource getPromotionsResource() {
        return (PromotionsResource)this.resourceContext.getResource(PromotionsResource.class);
    }

    @Path(value="audit")
    public AuditResource getAuditResource() {
        return (AuditResource)this.resourceContext.getResource(AuditResource.class);
    }
}

