/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.JsonPatch;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiExportService;
import io.gravitee.rest.api.service.JsonPatchService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.JsonPatchTestFailedException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collection;

@Tag(name="API Definition")
public class ApiDefinitionResource
extends AbstractResource {
    private static final String EXPORT_VERSION = "default";
    @Inject
    private ApiExportService apiExportService;
    @Inject
    private ApiDuplicatorService apiDuplicatorService;
    @Inject
    private JsonPatchService jsonPatchService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Export the API definition in JSON format", description="User must have the API_DEFINITION[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=JsonNode.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.READ})})
    public Response getApiDefinition() {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        String apiDefinition = this.apiExportService.exportAsJson(executionContext, this.api, EXPORT_VERSION, new String[0]);
        return Response.ok((Object)apiDefinition).build();
    }

    @PATCH
    @Produces(value={"application/json"})
    @Operation(summary="Update the API with json patches", description="User must have the API_DEFINITION[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API successfully updated with json patches", content={@Content(mediaType="application/json", schema=@Schema(implementation=JsonNode.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DEFINITION, acls={RolePermissionAction.UPDATE})})
    public Response patch(@RequestBody(required=true) @Valid @NotNull Collection<JsonPatch> patches, @QueryParam(value="dryRun") @DefaultValue(value="false") boolean dryRun) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiEntity apiEntity = this.getApi(executionContext);
        String apiDefinition = this.apiExportService.exportAsJson(executionContext, apiEntity.getId(), EXPORT_VERSION, new String[0]);
        try {
            String apiDefinitionModified = this.jsonPatchService.execute(apiDefinition, patches);
            if (dryRun) {
                return Response.ok((Object)apiDefinitionModified).build();
            }
            ApiEntity updatedApi = this.apiDuplicatorService.updateWithImportedDefinition(executionContext, (Object)apiDefinitionModified);
            String apiDefinitionUpdated = this.apiExportService.exportAsJson(executionContext, this.api, EXPORT_VERSION, new String[0]);
            return Response.ok((Object)apiDefinitionUpdated).tag(Long.toString(updatedApi.getUpdatedAt().getTime())).lastModified(updatedApi.getUpdatedAt()).build();
        }
        catch (JsonPatchTestFailedException e) {
            return Response.noContent().tag(Long.toString(apiEntity.getUpdatedAt().getTime())).lastModified(apiEntity.getUpdatedAt()).build();
        }
    }

    private ApiEntity getApi(ExecutionContext executionContext) {
        ApiEntity apiEntity = this.apiService.findById(executionContext, this.api);
        if (!this.canManageApi((GenericApiEntity)apiEntity)) {
            throw new ForbiddenAccessException();
        }
        return apiEntity;
    }
}

