/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.node.api.license.NodeLicenseService;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.v4.ApiAuthorizationService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.MatchingEntityTag;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;

public abstract class AbstractResource {
    public static final String ORGANIZATION_ADMIN = RoleScope.ORGANIZATION.name() + ":" + SystemRole.ADMIN.name();
    @Context
    protected SecurityContext securityContext;
    @Context
    protected UriInfo uriInfo;
    @Inject
    protected MembershipService membershipService;
    @Inject
    protected RoleService roleService;
    @Inject
    protected ApiService apiService;
    @Inject
    protected io.gravitee.rest.api.service.v4.ApiService apiServiceV4;
    @Inject
    protected ApiSearchService apiSearchService;
    @Inject
    protected ApiAuthorizationService apiAuthorizationService;
    @Inject
    protected PermissionService permissionService;
    @Inject
    protected NodeLicenseService nodeLicenseService;

    protected UserDetails getAuthenticatedUserDetails() {
        return (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    }

    protected String getAuthenticatedUser() {
        return this.securityContext.getUserPrincipal().getName();
    }

    protected String getAuthenticatedUserOrNull() {
        return this.isAuthenticated() ? this.getAuthenticatedUser() : null;
    }

    protected boolean isAuthenticated() {
        return this.securityContext.getUserPrincipal() != null;
    }

    protected boolean isAdmin() {
        return this.isUserInRole(ORGANIZATION_ADMIN);
    }

    private boolean isUserInRole(String role) {
        return this.securityContext.isUserInRole(role);
    }

    protected boolean hasPermission(ExecutionContext executionContext, RolePermission permission, RolePermissionAction ... acls) {
        return this.hasPermission(executionContext, permission, (String)null, acls);
    }

    protected boolean hasPermission(ExecutionContext executionContext, RolePermission permission, String referenceId, RolePermissionAction ... acls) {
        return this.isAuthenticated() && this.permissionService.hasPermission(executionContext, permission, referenceId, acls);
    }

    protected boolean canReadAPIConfiguration() {
        if (!this.isAdmin()) {
            return this.retrieveApiMembership().findFirst().isPresent();
        }
        return true;
    }

    private Stream<MembershipEntity> retrieveApiMembership() {
        Stream streamUserMembership = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, this.getAuthenticatedUser(), MembershipReferenceType.API).stream();
        Stream<MembershipEntity> streamGroupMembership = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, this.getAuthenticatedUser(), MembershipReferenceType.GROUP).stream().filter(m -> m.getRoleId() != null && this.roleService.findById(m.getRoleId()).getScope().equals((Object)RoleScope.API));
        return Stream.concat(streamUserMembership, streamGroupMembership);
    }

    protected boolean canManageApi(GenericApiEntity api) {
        return this.isAdmin() || this.isDirectMember(api.getId()) || this.isMemberThroughGroup(api.getGroups());
    }

    private boolean isDirectMember(String apiId) {
        return this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, this.getAuthenticatedUser(), MembershipReferenceType.API).stream().filter(membership -> membership.getReferenceId().equals(apiId)).filter(membership -> membership.getRoleId() != null).anyMatch(membership -> {
            RoleEntity role = this.roleService.findById(membership.getRoleId());
            return this.apiAuthorizationService.canManageApi(role);
        });
    }

    private boolean isMemberThroughGroup(Set<String> apiGroups) {
        if (CollectionUtils.isEmpty(apiGroups)) {
            return false;
        }
        Set groups = this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, this.getAuthenticatedUser(), MembershipReferenceType.GROUP).stream().filter(membership -> membership.getRoleId() != null).filter(membership -> {
            RoleEntity role = this.roleService.findById(membership.getRoleId());
            return this.apiAuthorizationService.canManageApi(role);
        }).map(MembershipEntity::getReferenceId).collect(Collectors.toSet());
        groups.retainAll(apiGroups);
        return !groups.isEmpty();
    }

    protected boolean isFeatureEnabled(String featureName) {
        return this.nodeLicenseService.isFeatureEnabled(featureName);
    }

    protected void canReadApi(ExecutionContext executionContext, String apiId) {
        if (!this.isAdmin()) {
            boolean canReadAPI;
            List memberships = this.retrieveApiMembership().collect(Collectors.toList());
            Optional<MembershipEntity> directMembershipEntity = memberships.stream().filter(m -> MembershipReferenceType.API.equals((Object)m.getReferenceType())).findAny();
            if (directMembershipEntity.isPresent()) {
                return;
            }
            Set groups = memberships.stream().filter(m -> MembershipReferenceType.GROUP.equals((Object)m.getReferenceType())).map(MembershipEntity::getReferenceId).collect(Collectors.toSet());
            ApiQuery apiQuery = new ApiQuery();
            apiQuery.setGroups(new ArrayList(groups));
            apiQuery.setIds(Collections.singletonList(apiId));
            List ids = this.apiService.searchIds(executionContext, apiQuery, (Pageable)new PageableImpl(1, 1), null).getContent();
            boolean bl = canReadAPI = ids != null && ids.contains(apiId);
            if (!canReadAPI) {
                throw new ForbiddenAccessException();
            }
        }
    }

    protected UriBuilder getRequestUriBuilder() {
        return this.uriInfo.getRequestUriBuilder();
    }

    protected URI getLocationHeader(String ... paths) {
        UriBuilder requestUriBuilder = this.uriInfo.getRequestUriBuilder();
        for (String path : paths) {
            requestUriBuilder.path(path);
        }
        return requestUriBuilder.build(new Object[0]);
    }

    protected Response.ResponseBuilder evaluateIfMatch(HttpHeaders headers, String etagValue) {
        String ifMatch = headers.getHeaderString("If-Match");
        if (ifMatch == null || ifMatch.isEmpty()) {
            return null;
        }
        ifMatch = ifMatch.replaceAll("-gzip", "");
        try {
            Set matchingTags = HttpHeaderReader.readMatchingEntityTag((String)ifMatch);
            MatchingEntityTag ifMatchHeader = (MatchingEntityTag)matchingTags.iterator().next();
            EntityTag eTag = new EntityTag(etagValue, ifMatchHeader.isWeak());
            return matchingTags != MatchingEntityTag.ANY_MATCH && !matchingTags.contains(eTag) ? Response.status((Response.Status)Response.Status.PRECONDITION_FAILED) : null;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

