/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NewTokenEntity;
import io.gravitee.rest.api.model.TokenEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.TokenService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.TokenNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Tag(name="User Tokens")
public class UserTokensResource
extends AbstractResource {
    @Inject
    private TokenService tokenService;
    @Inject
    private UserService userService;
    @PathParam(value="userId")
    @Parameter(name="userId", required=true, hidden=true)
    private String userId;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List user's personal tokens")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="User's personal tokens", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TokenEntity.class)))}), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.READ})})
    public List<TokenEntity> getUserTokens() {
        this.userService.findById(GraviteeContext.getExecutionContext(), this.userId);
        return this.tokenService.findByUser(this.userId).stream().sorted(Comparator.comparing(TokenEntity::getCreatedAt)).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a personal token")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="A new personal token", content={@Content(mediaType="application/json", schema=@Schema(implementation=TokenEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.READ, RolePermissionAction.CREATE})})
    public Response createToken(@Valid @NotNull NewTokenEntity token) {
        this.userService.findById(GraviteeContext.getExecutionContext(), this.userId);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.tokenService.create(GraviteeContext.getExecutionContext(), token, this.userId)).build();
    }

    @Path(value="{token}")
    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Revoke a single user's personal tokens")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="User's personal token revoked"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_USERS, acls={RolePermissionAction.READ, RolePermissionAction.DELETE})})
    public void revokeToken(@PathParam(value="token") String tokenId) {
        this.userService.findById(GraviteeContext.getExecutionContext(), this.userId);
        if (!this.tokenService.tokenExistsForUser(tokenId, this.userId)) {
            throw new TokenNotFoundException(tokenId);
        }
        this.tokenService.revoke(GraviteeContext.getExecutionContext(), tokenId);
    }
}

