/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.installation;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.InstallationEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.InstallationService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Tag(name="Console")
@Hidden
public class InstallationResource {
    @Inject
    private InstallationService installationService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get installation information", description="User must have the ORGANIZATION_INSTALLATION[READ] permission on the platform")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Installation definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=InstallationEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_INSTALLATION, acls={RolePermissionAction.READ})})
    public Response getInstallation() {
        return Response.ok((Object)this.installationService.get()).build();
    }
}

