/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.configuration.identity;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderEntity;
import io.gravitee.rest.api.model.configuration.identity.UpdateIdentityProviderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderService;
import io.gravitee.rest.api.service.impl.configuration.identity.IdentityProviderNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Tags(value={@Tag(name="Configuration"), @Tag(name="Identity Providers")})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IdentityProviderResource
extends AbstractResource {
    @Autowired
    private IdentityProviderService identityProviderService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get an identity provider", description="User must have the ORGANIZATION_IDENTITY_PROVIDER[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="An identity provider", content={@Content(mediaType="application/json", schema=@Schema(implementation=IdentityProviderEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER, acls={RolePermissionAction.READ})})
    public IdentityProviderEntity getIdentityProvider(@PathParam(value="identityProvider") String identityProvider) {
        IdentityProviderEntity identityProviderEntity = this.identityProviderService.findById(identityProvider);
        if (!identityProviderEntity.getOrganization().equalsIgnoreCase(GraviteeContext.getCurrentOrganization())) {
            throw new IdentityProviderNotFoundException(identityProvider);
        }
        return identityProviderEntity;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an identity provider", description="User must have the ORGANIZATION_IDENTITY_PROVIDER[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated identity provider", content={@Content(mediaType="application/json", schema=@Schema(implementation=IdentityProviderEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER, acls={RolePermissionAction.UPDATE})})
    public IdentityProviderEntity updateIdentityProvider(@PathParam(value="identityProvider") String identityProvider, @Parameter(name="identityProviderEntity", required=true) @Valid @NotNull UpdateIdentityProviderEntity updatedIdentityProvider) {
        return this.identityProviderService.update(GraviteeContext.getExecutionContext(), identityProvider, updatedIdentityProvider);
    }

    @DELETE
    @Operation(summary="Delete an identity provider", description="User must have the ORGANIZATION_IDENTITY_PROVIDER[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Identity provider successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_IDENTITY_PROVIDER, acls={RolePermissionAction.DELETE})})
    public Response deleteIdentityProvider(@PathParam(value="identityProvider") String identityProvider) {
        this.identityProviderService.delete(GraviteeContext.getExecutionContext(), identityProvider);
        return Response.noContent().build();
    }
}

