/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.filter;

import io.gravitee.node.api.license.NodeLicenseService;
import io.gravitee.rest.api.management.rest.security.GraviteeLicenseFeature;
import io.gravitee.rest.api.service.exceptions.ForbiddenFeatureException;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.util.Optional;

public class GraviteeLicenseFilter
implements ContainerRequestFilter {
    @Context
    protected ResourceInfo resourceInfo;
    @Inject
    private NodeLicenseService nodeLicenseService;

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        this.findRequiredGraviteeLicenseFeature().ifPresent(this::checkGraviteeLicenseFeature);
    }

    private void checkGraviteeLicenseFeature(GraviteeLicenseFeature requiredFeature) {
        String featureName = requiredFeature.value();
        if (this.nodeLicenseService.isFeatureMissing(featureName)) {
            throw new ForbiddenFeatureException(featureName);
        }
    }

    private Optional<GraviteeLicenseFeature> findRequiredGraviteeLicenseFeature() {
        GraviteeLicenseFeature annotation = this.resourceInfo.getResourceMethod().getAnnotation(GraviteeLicenseFeature.class);
        return Optional.ofNullable(annotation);
    }
}

