/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.ServiceDiscoveryResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ResourceListItem;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.service.ServiceDiscoveryService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(name="Plugins")
public class ServicesDiscoveryResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ServiceDiscoveryService serviceDiscoveryService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List service discovery plugins", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of service discovery plugins", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ResourceListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Collection<ResourceListItem> getServicesDiscoverResources(@QueryParam(value="expand") List<String> expand) {
        Stream<ResourceListItem> stream = this.serviceDiscoveryService.findAll().stream().map(this::convert);
        if (expand != null && !expand.isEmpty()) {
            Iterator<String> iterator = expand.iterator();
            while (iterator.hasNext()) {
                String s;
                switch (s = iterator.next()) {
                    case "schema": {
                        stream = stream.map(resourceListItem -> {
                            resourceListItem.setSchema(this.serviceDiscoveryService.getSchema(resourceListItem.getId()));
                            return resourceListItem;
                        });
                        break;
                    }
                }
            }
        }
        return stream.sorted(Comparator.comparing(ResourceListItem::getName)).collect(Collectors.toList());
    }

    @Path(value="{plugin}")
    public ServiceDiscoveryResource getServiceDiscoveryResource() {
        return (ServiceDiscoveryResource)this.resourceContext.getResource(ServiceDiscoveryResource.class);
    }

    private ResourceListItem convert(PlatformPluginEntity pluginEntity) {
        ResourceListItem item = new ResourceListItem();
        item.setId(pluginEntity.getId());
        item.setName(pluginEntity.getName());
        item.setDescription(pluginEntity.getDescription());
        item.setVersion(pluginEntity.getVersion());
        return item;
    }
}

