/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.InstanceEntity;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.monitoring.MonitoringData;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.InstanceService;
import io.gravitee.rest.api.service.MonitoringService;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.InstanceNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Tag(name="Gateway")
public class MonitoringResource
extends AbstractResource {
    @Inject
    private MonitoringService monitoringService;
    @Inject
    private InstanceService instanceService;
    @Inject
    private OrganizationService organizationService;
    @PathParam(value="instance")
    @Parameter(name="instance", hidden=true)
    private String instance;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get monitoring metrics for a gateway instance")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public MonitoringData getInstanceMonitoring(@PathParam(value="gatewayId") String gatewayId) {
        InstanceEntity instanceEntity = this.instanceService.findByEvent(GraviteeContext.getExecutionContext(), this.instance);
        if (!this.isInstanceAccessibleByEnv(instanceEntity.getEnvironments(), GraviteeContext.getCurrentEnvironment()) || !this.isInstanceAccessibleByOrga(instanceEntity.getOrganizationsHrids(), GraviteeContext.getCurrentOrganization())) {
            throw new InstanceNotFoundException(this.instance);
        }
        return this.monitoringService.findMonitoring(gatewayId);
    }

    private boolean isInstanceAccessibleByOrga(List<String> organizationsHrids, String currentOrganization) {
        if (organizationsHrids == null || organizationsHrids.isEmpty()) {
            return true;
        }
        return this.organizationService.findByHrids(new HashSet<String>(organizationsHrids)).stream().map(OrganizationEntity::getId).anyMatch(id -> id.equalsIgnoreCase(currentOrganization));
    }

    private boolean isInstanceAccessibleByEnv(Set<String> environments, String currentEnvironment) {
        return environments == null || environments.isEmpty() || environments.contains(currentEnvironment);
    }
}

