/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.MonitoringResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.InstanceEntity;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.InstanceService;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.InstanceNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Tag(name="Gateway")
public class InstanceResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private InstanceService instanceService;
    @Inject
    private OrganizationService organizationService;
    @PathParam(value="instance")
    private String instance;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a gateway instance")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_INSTANCE, acls={RolePermissionAction.READ})})
    public InstanceEntity getInstance() {
        InstanceEntity instanceEntity = this.instanceService.findByEvent(GraviteeContext.getExecutionContext(), this.instance);
        if (this.isInstanceAccessibleByEnv(instanceEntity.getEnvironments(), GraviteeContext.getCurrentEnvironment()) && this.isInstanceAccessibleByOrga(instanceEntity.getOrganizationsHrids(), GraviteeContext.getCurrentOrganization())) {
            return instanceEntity;
        }
        throw new InstanceNotFoundException(this.instance);
    }

    @Path(value="monitoring/{gatewayId}")
    public MonitoringResource getMonitoringResource() {
        return (MonitoringResource)this.resourceContext.getResource(MonitoringResource.class);
    }

    private boolean isInstanceAccessibleByOrga(List<String> organizationsHrids, String currentOrganization) {
        if (organizationsHrids == null || organizationsHrids.isEmpty()) {
            return true;
        }
        return this.organizationService.findByHrids(new HashSet<String>(organizationsHrids)).stream().map(OrganizationEntity::getId).anyMatch(id -> id.equalsIgnoreCase(currentOrganization));
    }

    private boolean isInstanceAccessibleByEnv(Set<String> environments, String currentEnvironment) {
        return environments == null || environments.isEmpty() || environments.contains(currentEnvironment);
    }
}

