/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.platform.plugin.PlatformPluginEntity;
import io.gravitee.rest.api.service.ConnectorService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;

@Tag(name="Plugins")
public class ConnectorResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ConnectorService connectorService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a connector", description="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connector plugin", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlatformPluginEntity.class))}), @ApiResponse(responseCode="404", description="Connector not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public PlatformPluginEntity getConnector(@PathParam(value="connector") String connector) {
        return this.connectorService.findById(connector);
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @Operation(summary="Get a connector's schema", description="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connector schema", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Connector not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getConnectorSchema(@PathParam(value="connector") String connector) {
        this.connectorService.findById(connector);
        return this.connectorService.getSchema(connector);
    }

    @GET
    @Path(value="documentation")
    @Produces(value={"text/plain"})
    @Operation(summary="Get a connector's documentation", description="User must have the ENVIRONMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Connector documentation", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Connector not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getConnectorDoc(@PathParam(value="connector") String connector) {
        this.connectorService.findById(connector);
        return this.connectorService.getDocumentation(connector);
    }
}

