/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscriptionApiKeysResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.ProcessSubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.TransferSubscriptionEntity;
import io.gravitee.rest.api.model.UpdateSubscriptionEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanMode;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Tag(name="API Subscriptions")
public class ApiSubscriptionResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private PlanSearchService planSearchService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private UserService userService;
    @Inject
    private ParameterService parameterService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a subscription", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Get a subscription", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="404", description="Subscription does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public Subscription getApiSubscription(@PathParam(value="subscription") String subscription) {
        return this.convert(GraviteeContext.getExecutionContext(), this.checkSubscription(subscription));
    }

    @POST
    @Path(value="/_process")
    @Produces(value={"application/json"})
    @Operation(summary="Update a subscription", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Update a subscription", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="Bad subscription format"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response processApiSubscription(@PathParam(value="subscription") String subscription, @Parameter(name="subscription", required=true) @Valid @NotNull ProcessSubscriptionEntity processSubscriptionEntity) {
        if (processSubscriptionEntity.getId() != null && !subscription.equals(processSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to process").build();
        }
        this.checkSubscription(subscription);
        processSubscriptionEntity.setId(subscription);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        SubscriptionEntity subscriptionEntity = this.subscriptionService.process(executionContext, processSubscriptionEntity, this.getAuthenticatedUser());
        return Response.ok((Object)this.convert(executionContext, subscriptionEntity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a subscription", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Update a subscription", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="Bad subscription format"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response updateApiSubscription(@PathParam(value="subscription") String subscription, @Parameter(name="subscription", required=true) @Valid @NotNull UpdateSubscriptionEntity updateSubscriptionEntity) {
        if (updateSubscriptionEntity.getId() != null && !subscription.equals(updateSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to update").build();
        }
        this.checkSubscription(subscription);
        updateSubscriptionEntity.setId(subscription);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        SubscriptionEntity subscriptionEntity = this.subscriptionService.update(executionContext, updateSubscriptionEntity);
        return Response.ok((Object)this.convert(executionContext, subscriptionEntity)).build();
    }

    @POST
    @Path(value="/status")
    @Produces(value={"application/json"})
    @Operation(summary="Change the status of a subscription", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Subscription status successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="Status changes not authorized"), @ApiResponse(responseCode="404", description="API subscription does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response changeApiSubscriptionStatus(@PathParam(value="subscription") String subscription, @Parameter(required=true, schema=@Schema(allowableValues={"CLOSED", "PAUSED", "RESUMED"})) @QueryParam(value="status") SubscriptionStatus subscriptionStatus) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (SubscriptionStatus.CLOSED.equals((Object)subscriptionStatus)) {
            SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.close(executionContext, subscription);
            return Response.ok((Object)this.convert(executionContext, updatedSubscriptionEntity)).build();
        }
        if (SubscriptionStatus.PAUSED.equals((Object)subscriptionStatus)) {
            SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.pause(executionContext, subscription);
            return Response.ok((Object)this.convert(executionContext, updatedSubscriptionEntity)).build();
        }
        if (SubscriptionStatus.RESUMED.equals((Object)subscriptionStatus)) {
            SubscriptionEntity updatedSubscriptionEntity = this.subscriptionService.resume(executionContext, subscription);
            return Response.ok((Object)this.convert(executionContext, updatedSubscriptionEntity)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @POST
    @Path(value="/_transfer")
    @Produces(value={"application/json"})
    @Operation(summary="Transfer a subscription", description="User must have the API_SUBSCRIPTION update permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Update a subscription", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="Bad subscription format"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.UPDATE})})
    public Response transferApiSubscription(@PathParam(value="subscription") String subscription, @Parameter(name="subscription", required=true) @Valid @NotNull TransferSubscriptionEntity transferSubscriptionEntity) {
        if (transferSubscriptionEntity.getId() != null && !subscription.equals(transferSubscriptionEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'subscription' parameter does not correspond to the subscription to process").build();
        }
        this.checkSubscription(subscription);
        transferSubscriptionEntity.setId(subscription);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        SubscriptionEntity subscriptionEntity = this.subscriptionService.transfer(executionContext, transferSubscriptionEntity, this.getAuthenticatedUser());
        return Response.ok((Object)this.convert(executionContext, subscriptionEntity)).build();
    }

    private Subscription convert(ExecutionContext executionContext, SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setRequest(subscriptionEntity.getRequest());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setConsumerStatus(subscriptionEntity.getConsumerStatus());
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(executionContext, subscriptionEntity.getSubscribedBy(), true).getDisplayName()));
        subscription.setClientId(subscriptionEntity.getClientId());
        subscription.setMetadata(subscriptionEntity.getMetadata());
        GenericPlanEntity plan = this.planSearchService.findById(executionContext, subscriptionEntity.getPlan());
        subscription.setPlan(new Subscription.Plan(plan.getId(), plan.getName()));
        if (plan.getPlanMode() == PlanMode.STANDARD) {
            subscription.getPlan().setSecurity(plan.getPlanSecurity().getType());
        }
        ApplicationEntity application = this.applicationService.findById(executionContext, subscriptionEntity.getApplication());
        subscription.setApplication(new Subscription.Application(application.getId(), application.getName(), application.getType(), application.getDescription(), application.getDomain(), new Subscription.User(application.getPrimaryOwner().getId(), application.getPrimaryOwner().getDisplayName()), application.getApiKeyMode()));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        subscription.setPausedAt(subscriptionEntity.getPausedAt());
        subscription.setConsumerPausedAt(subscriptionEntity.getConsumerPausedAt());
        return subscription;
    }

    @Path(value="apikeys")
    public ApiSubscriptionApiKeysResource getApiSubscriptionApiKeysResourceResource() {
        return (ApiSubscriptionApiKeysResource)this.resourceContext.getResource(ApiSubscriptionApiKeysResource.class);
    }

    private SubscriptionEntity checkSubscription(String subscription) {
        SubscriptionEntity searchedSubscription = this.subscriptionService.findById(subscription);
        if (this.api.equalsIgnoreCase(searchedSubscription.getApi())) {
            return searchedSubscription;
        }
        throw new SubscriptionNotFoundException(subscription);
    }
}

