/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.PlanSecurityParam;
import io.gravitee.rest.api.management.rest.resource.param.PlanStatusParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.BasePlanEntity;
import io.gravitee.rest.api.model.NewPlanEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanType;
import io.gravitee.rest.api.model.UpdatePlanEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Tag(name="API Plans")
public class ApiPlansResource
extends AbstractResource {
    @Inject
    private PlanService planService;
    @Inject
    private ApiService apiService;
    @Inject
    private GroupService groupService;
    @Context
    private ResourceContext resourceContext;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List plans for an API", description="List all the plans accessible to the current user.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List accessible plans for current user", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=PlanEntity.class), uniqueItems=true))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<PlanEntity> getApiPlans(@QueryParam(value="status") @DefaultValue(value="PUBLISHED") @Parameter(explode=Explode.FALSE, schema=@Schema(type="array")) PlanStatusParam wishedStatus, @QueryParam(value="security") @Parameter(explode=Explode.FALSE, schema=@Schema(type="array")) PlanSecurityParam security) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        ApiEntity apiEntity = this.apiService.findById(executionContext, this.api);
        if (!this.hasPermission(executionContext, RolePermission.API_PLAN, this.api, RolePermissionAction.READ) && !this.hasPermission(executionContext, RolePermission.API_LOG, this.api, RolePermissionAction.READ) && apiEntity.getVisibility() == Visibility.PRIVATE) {
            throw new ForbiddenAccessException();
        }
        return this.planService.findByApi(executionContext, this.api).stream().filter(plan -> wishedStatus.contains(plan.getStatus()) && (this.isAuthenticated() && this.isAdmin() || this.groupService.isUserAuthorizedToAccessApiData((GenericApiEntity)apiEntity, plan.getExcludedGroups(), this.getAuthenticatedUserOrNull()))).filter(plan -> security == null || security.contains(plan.getSecurity())).sorted(Comparator.comparingInt(BasePlanEntity::getOrder)).map(this::filterSensitiveData).collect(Collectors.toList());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a plan", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Plan successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.CREATE})})
    public Response createApiPlan(@Parameter(name="plan", required=true) @Valid @NotNull NewPlanEntity newPlanEntity) {
        newPlanEntity.setApi(this.api);
        newPlanEntity.setType(PlanType.API);
        PlanEntity planEntity = this.planService.create(GraviteeContext.getExecutionContext(), newPlanEntity);
        return Response.created((URI)this.getLocationHeader(planEntity.getId())).entity((Object)planEntity).build();
    }

    @PUT
    @Path(value="/{plan}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a plan", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Plan successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="400", description="Bad plan format"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.UPDATE})})
    public Response updateApiPlan(@PathParam(value="plan") String plan, @Parameter(name="plan", required=true) @Valid @NotNull UpdatePlanEntity updatePlanEntity) {
        if (updatePlanEntity.getId() != null && !plan.equals(updatePlanEntity.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the plan to update").build();
        }
        updatePlanEntity.setId(plan);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        PlanEntity planEntity = this.planService.findById(executionContext, plan);
        if (!planEntity.getApi().contains(this.api)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
        }
        planEntity = this.planService.update(executionContext, updatePlanEntity);
        return Response.ok((Object)planEntity).build();
    }

    @GET
    @Path(value="/{plan}")
    @Produces(value={"application/json"})
    @Operation(summary="Get a plan", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Plan information", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getApiPlan(@PathParam(value="plan") String plan) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (Visibility.PUBLIC.equals((Object)this.apiService.findById(executionContext, this.api).getVisibility()) || this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_PLAN, this.api, RolePermissionAction.READ)) {
            PlanEntity planEntity = this.planService.findById(executionContext, plan);
            if (!planEntity.getApi().equals(this.api)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
            }
            return Response.ok((Object)planEntity).build();
        }
        throw new ForbiddenAccessException();
    }

    @DELETE
    @Path(value="/{plan}")
    @Produces(value={"application/json"})
    @Operation(summary="Delete a plan", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Plan successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.DELETE})})
    public Response deleteApiPlan(@PathParam(value="plan") String plan) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        PlanEntity planEntity = this.planService.findById(executionContext, plan);
        if (!planEntity.getApi().equals(this.api)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
        }
        this.planService.delete(executionContext, plan);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/{plan}/_close")
    @Produces(value={"application/json"})
    @Operation(summary="Close  a plan", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Plan successfully closed", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.UPDATE})})
    public Response closeApiPlan(@PathParam(value="plan") String plan) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        PlanEntity planEntity = this.planService.findById(executionContext, plan);
        if (!planEntity.getApi().equals(this.api)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
        }
        PlanEntity closedPlan = this.planService.close(executionContext, plan);
        return Response.ok((Object)closedPlan).build();
    }

    @POST
    @Path(value="/{plan}/_publish")
    @Produces(value={"application/json"})
    @Operation(summary="Publicly publish plan", description="User must have the MANAGE_PLANS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Plan successfully published", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.UPDATE})})
    public Response publishApiPlan(@PathParam(value="plan") String plan) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        PlanEntity planEntity = this.planService.findById(executionContext, plan);
        if (!planEntity.getApi().equals(this.api)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
        }
        return Response.ok((Object)this.planService.publish(executionContext, plan)).build();
    }

    @POST
    @Deprecated
    @Path(value="/{plan}/_depreciate")
    @Produces(value={"application/json"})
    @Operation(summary="Deprecated, use '_deprecate' instead. Deprecate a plan", deprecated=true, description="User must have the API_PLAN[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Plan successfully deprecated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.UPDATE})})
    public Response depreciateApiPlan(@PathParam(value="plan") String plan) {
        return this.deprecateApiPlan(plan);
    }

    @POST
    @Path(value="/{plan}/_deprecate")
    @Produces(value={"application/json"})
    @Operation(summary="Deprecate a plan", description="User must have the API_PLAN[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Plan successfully deprecated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_PLAN, acls={RolePermissionAction.UPDATE})})
    public Response deprecateApiPlan(@PathParam(value="plan") String plan) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        PlanEntity planEntity = this.planService.findById(executionContext, plan);
        if (!planEntity.getApi().equals(this.api)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'plan' parameter does not correspond to the current API").build();
        }
        return Response.ok((Object)this.planService.deprecate(executionContext, plan)).build();
    }

    private PlanEntity filterSensitiveData(PlanEntity entity) {
        if (this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_GATEWAY_DEFINITION, entity.getApi(), RolePermissionAction.READ) && this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_PLAN, entity.getApi(), RolePermissionAction.READ)) {
            return entity;
        }
        PlanEntity filtered = new PlanEntity();
        filtered.setId(entity.getId());
        filtered.setCharacteristics(entity.getCharacteristics());
        filtered.setName(entity.getName());
        filtered.setDescription(entity.getDescription());
        filtered.setOrder(entity.getOrder());
        filtered.setSecurity(entity.getSecurity());
        filtered.setType(filtered.getType());
        filtered.setValidation(filtered.getValidation());
        filtered.setCommentRequired(entity.isCommentRequired());
        filtered.setCommentMessage(entity.getCommentMessage());
        filtered.setGeneralConditions(entity.getGeneralConditions());
        return filtered;
    }
}

