/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiPageResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.management.rest.utils.HttpHeadersUtil;
import io.gravitee.rest.api.model.ImportPageEntity;
import io.gravitee.rest.api.model.NewPageEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.AccessControlService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.PageMarkdownTemplateActionException;
import io.gravitee.rest.api.service.exceptions.PageSystemFolderActionException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;

@Tag(name="API Pages")
public class ApiPagesResource
extends AbstractResource {
    @Inject
    private PageService pageService;
    @Inject
    private AccessControlService accessControlService;
    @Context
    private ResourceContext resourceContext;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List pages", description="User must have the READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of pages", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=PageEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<PageEntity> getApiPages(@HeaderParam(value="Accept-Language") String acceptLang, @QueryParam(value="homepage") Boolean homepage, @QueryParam(value="type") PageType type, @QueryParam(value="parent") String parent, @QueryParam(value="name") String name, @QueryParam(value="root") Boolean rootParent, @QueryParam(value="translated") boolean translated) {
        String acceptedLocale = HttpHeadersUtil.getFirstAcceptedLocaleName(acceptLang);
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, this.api);
        if (Visibility.PUBLIC.equals((Object)genericApiEntity.getVisibility()) || this.hasPermission(executionContext, RolePermission.API_DOCUMENTATION, this.api, RolePermissionAction.READ)) {
            return this.pageService.search(executionContext.getEnvironmentId(), new PageQuery.Builder().api(this.api).homepage(homepage).type(type).parent(parent).name(name).rootParent(rootParent).build(), translated ? acceptedLocale : null).stream().filter(page -> this.isDisplayable(genericApiEntity, (PageEntity)page)).map(page -> {
                page.setGeneralConditions(this.pageService.isPageUsedAsGeneralConditions(executionContext, page, this.api));
                return page;
            }).collect(Collectors.toList());
        }
        throw new ForbiddenAccessException();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a page", description="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public Response createApiPage(@Parameter(name="page", required=true) @Valid @NotNull NewPageEntity newPageEntity) {
        if (newPageEntity.getType().equals((Object)PageType.SYSTEM_FOLDER)) {
            throw new PageSystemFolderActionException("Create");
        }
        if (newPageEntity.getType().equals((Object)PageType.MARKDOWN_TEMPLATE)) {
            throw new PageMarkdownTemplateActionException("Create");
        }
        int order = this.pageService.findMaxApiPageOrderByApi(this.api) + 1;
        newPageEntity.setOrder(order);
        newPageEntity.setLastContributor(this.getAuthenticatedUser());
        PageEntity newPage = this.pageService.createPage(GraviteeContext.getExecutionContext(), this.api, newPageEntity);
        if (newPage != null) {
            return Response.created((URI)this.getLocationHeader(newPage.getId())).entity((Object)newPage).build();
        }
        return Response.serverError().build();
    }

    @POST
    @Path(value="/_fetch")
    @Produces(value={"application/json"})
    @Operation(summary="Refresh all pages by calling their associated fetcher", description="User must have the MANAGE_PAGES permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Pages successfully refreshed", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.UPDATE})})
    public Response fetchAllApiPages() {
        String contributor = this.getAuthenticatedUser();
        this.pageService.fetchAll(GraviteeContext.getExecutionContext(), new PageQuery.Builder().api(this.api).build(), contributor);
        return Response.noContent().build();
    }

    @Path(value="{page}")
    public ApiPageResource getApiPageResource() {
        return (ApiPageResource)this.resourceContext.getResource(ApiPageResource.class);
    }

    @POST
    @Path(value="/_import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Import pages", description="User must be ADMIN to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public List<PageEntity> importApiPageFiles(@Parameter(name="page", required=true) @Valid @NotNull ImportPageEntity pageEntity) {
        pageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.importFiles(GraviteeContext.getExecutionContext(), this.api, pageEntity);
    }

    @PUT
    @Path(value="/_import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Import pages", description="User must be ADMIN to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Page successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    public List<PageEntity> updateApiPageImportFiles(@Parameter(name="page", required=true) @Valid @NotNull ImportPageEntity pageEntity) {
        pageEntity.setLastContributor(this.getAuthenticatedUser());
        return this.pageService.importFiles(GraviteeContext.getExecutionContext(), this.api, pageEntity);
    }

    private boolean isDisplayable(GenericApiEntity genericApiEntity, PageEntity page) {
        return this.isAuthenticated() && this.isAdmin() || this.accessControlService.canAccessPageFromConsole(GraviteeContext.getExecutionContext(), genericApiEntity, page);
    }
}

