/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiHeaderResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.api.header.NewApiHeaderEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApiHeaderService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.List;

@Tag(name="Configuration")
public class ApiHeadersResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private ApiHeaderService apiHeaderService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List API headers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of API headers", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApiHeaderEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API_HEADER, acls={RolePermissionAction.READ})})
    public List<ApiHeaderEntity> getApiHeaders() {
        return this.apiHeaderService.findAll(GraviteeContext.getCurrentEnvironment());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an API header", description="User must have the PORTAL_API_HEADER[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API header successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApiHeaderEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API_HEADER, acls={RolePermissionAction.CREATE})})
    public ApiHeaderEntity createApiHeader(@Valid @NotNull NewApiHeaderEntity newApiHeaderEntity) {
        return this.apiHeaderService.create(GraviteeContext.getExecutionContext(), newApiHeaderEntity);
    }

    @Path(value="{id}")
    public ApiHeaderResource getApiHeaderResource() {
        return (ApiHeaderResource)this.resourceContext.getResource(ApiHeaderResource.class);
    }
}

