/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.MetadataPage;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.AuditParam;
import io.gravitee.rest.api.management.rest.security.GraviteeLicenseFeature;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.audit.AuditEntity;
import io.gravitee.rest.api.model.audit.AuditQuery;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Tag(name="API Audits")
public class ApiAuditResource
extends AbstractResource {
    private static final List<Audit.AuditEvent> events = new ArrayList<Audit.AuditEvent>();
    @Inject
    private AuditService auditService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Operation(summary="Retrieve audit logs for the API", description="User must have the API_AUDIT[READ] permission to use this service")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_AUDIT, acls={RolePermissionAction.READ})})
    @GraviteeLicenseFeature(value="apim-audit-trail")
    public MetadataPage<AuditEntity> getApiAudits(@BeanParam AuditParam param) {
        AuditQuery query = new AuditQuery();
        query.setFrom(param.getFrom());
        query.setTo(param.getTo());
        query.setPage(param.getPage());
        query.setSize(param.getSize());
        query.setApiIds(Collections.singletonList(this.api));
        query.setApplicationIds(Collections.emptyList());
        if (param.getEvent() != null) {
            query.setEvents(Collections.singletonList(param.getEvent()));
        }
        return this.auditService.search(GraviteeContext.getExecutionContext(), query);
    }

    @Path(value="/events")
    @GET
    @Operation(summary="List available audit event type for API", description="User must have the API_AUDIT[READ] permission to use this service")
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.API_AUDIT, acls={RolePermissionAction.READ})})
    public Response getApiAuditEvents() {
        if (events.isEmpty()) {
            Set subTypesOf = new Reflections("io.gravitee.repository.management.model", new Scanner[0]).getSubTypesOf(Audit.ApiAuditEvent.class);
            for (Class clazz : subTypesOf) {
                if (!clazz.isEnum()) continue;
                events.addAll(Arrays.asList((Audit.ApiAuditEvent[])clazz.getEnumConstants()));
            }
            events.sort(Comparator.comparing(Audit.AuditEvent::name));
        }
        return Response.ok(events).build();
    }
}

