/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.model.RoleMembership;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.RoleUserResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MembershipListItem;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Tag(name="Roles")
public class RoleUsersResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private MembershipService membershipService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List users with the given role", description="User must have the MANAGEMENT_ROLE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="List of user's memberships", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=MembershipListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.READ})})
    public List<MembershipListItem> getUsersPerRole(@PathParam(value="scope") RoleScope scope, @PathParam(value="role") String role) {
        Optional optRole;
        if (RoleScope.ORGANIZATION.equals((Object)scope) && (optRole = this.roleService.findByScopeAndName(scope, role, GraviteeContext.getCurrentOrganization())).isPresent()) {
            Set members = this.membershipService.getMembersByReferenceAndRole(GraviteeContext.getExecutionContext(), MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization(), ((RoleEntity)optRole.get()).getId());
            return members.stream().filter(Objects::nonNull).map(MembershipListItem::new).sorted((a, b) -> {
                if (a.getDisplayName() == null && b.getDisplayName() == null) {
                    return a.getId().compareToIgnoreCase(b.getId());
                }
                if (a.getDisplayName() == null) {
                    return -1;
                }
                if (b.getDisplayName() == null) {
                    return 1;
                }
                return a.getDisplayName().compareToIgnoreCase(b.getDisplayName());
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Add or update a role for a user", description="User must have the MANAGEMENT_ROLE[CREATE] and MANAGEMENT_ROLE[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Membership successfully created / updated"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.CREATE}), @Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.UPDATE})})
    public Response addRoleToUser(@Parameter(name="scope", required=true, schema=@Schema(allowableValues={"ORGANIZATION", "ENVIRONMENT"})) @PathParam(value="scope") RoleScope roleScope, @PathParam(value="role") String roleName, @Valid @NotNull RoleMembership roleMembership) {
        if (roleScope == null || roleName == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Role must be set").build();
        }
        Object referenceType = null;
        Object referenceId = null;
        if (!RoleScope.ORGANIZATION.equals((Object)roleScope)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Can't determine context").build();
        }
        this.membershipService.addRoleToMemberOnReference(GraviteeContext.getExecutionContext(), new MembershipService.MembershipReference(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization()), new MembershipService.MembershipMember(roleMembership.getId(), roleMembership.getReference(), MembershipMemberType.USER), new MembershipService.MembershipRole(roleScope, roleName));
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @Path(value="{userId}")
    public RoleUserResource getRoleUserResource() {
        return (RoleUserResource)this.resourceContext.getResource(RoleUserResource.class);
    }
}

