/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.quality;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.quality.QualityRuleResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.quality.NewQualityRuleEntity;
import io.gravitee.rest.api.model.quality.QualityRuleEntity;
import io.gravitee.rest.api.service.QualityRuleService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.List;

@Tag(name="Configuration")
public class QualityRulesResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private QualityRuleService qualityRuleService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List quality rules")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of quality rules", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=QualityRuleEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<QualityRuleEntity> getQualityRules() {
        if (!this.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.ENVIRONMENT_QUALITY_RULE, RolePermissionAction.READ) && !this.canReadAPIConfiguration()) {
            throw new ForbiddenAccessException();
        }
        return this.qualityRuleService.findAll();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a quality rule", description="User must have the MANAGEMENT_QUALITY_RULE[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Quality rule successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=QualityRuleEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_QUALITY_RULE, acls={RolePermissionAction.CREATE})})
    public QualityRuleEntity createQualityRule(@Valid @NotNull NewQualityRuleEntity newQualityRuleEntity) {
        return this.qualityRuleService.create(GraviteeContext.getExecutionContext(), newQualityRuleEntity);
    }

    @Path(value="{id}")
    public QualityRuleResource getQualityRuleResource() {
        return (QualityRuleResource)this.resourceContext.getResource(QualityRuleResource.class);
    }
}

