/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.GroupSimpleEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Tag(name="Organization Groups")
public class OrganizationGroupsResource
extends AbstractResource {
    @Inject
    private GroupService groupService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Find groups", description="Find all groups for current organizationOnly users with ORGANIZATION_TAG permissions could see API groups.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of groups", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GroupSimpleEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_TAG, acls={RolePermissionAction.READ})})
    public Response getGroups() {
        return Response.ok((Object)this.groupService.findAllByOrganization(GraviteeContext.getCurrentOrganization())).build();
    }
}

