/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.exception.InvalidImageException;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.security.utils.ImageUtils;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.UploadUnauthorized;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Tag(name="Portal Media")
public class PortalMediaResource
extends AbstractResource {
    @Inject
    private MediaService mediaService;

    @POST
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DOCUMENTATION, acls={RolePermissionAction.CREATE})})
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Operation(summary="Create a media for the portal", description="User must have the PORTAL_DOCUMENTATION[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Media successfully created", content={@Content(mediaType="text/plain", schema=@Schema(type="string"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response uploadPortalMedia(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="file") FormDataBodyPart body) throws IOException {
        if (fileDetail.getSize() > this.mediaService.getMediaMaxSize(GraviteeContext.getExecutionContext())) {
            throw new UploadUnauthorized("Max size achieved " + fileDetail.getSize());
        }
        MediaEntity mediaEntity = new MediaEntity();
        mediaEntity.setSize(fileDetail.getSize());
        mediaEntity.setType(body.getMediaType().getType());
        mediaEntity.setSubType(body.getMediaType().getSubtype());
        mediaEntity.setData(IOUtils.toByteArray((InputStream)uploadedInputStream));
        mediaEntity.setFileName(fileDetail.getFileName());
        try {
            ImageUtils.verify((String)body.getMediaType().getType(), (String)body.getMediaType().getSubtype(), (byte[])mediaEntity.getData());
        }
        catch (InvalidImageException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid image format").build();
        }
        String mediaId = this.mediaService.savePortalMedia(mediaEntity);
        return Response.status((int)200).entity((Object)mediaId).build();
    }

    @GET
    @Path(value="/{hash}")
    @Operation(summary="Retrieve a media")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A media", content={@Content(mediaType="*/*", schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getPortalMedia(@Context Request request, @PathParam(value="hash") String hash) {
        MediaEntity mediaEntity = this.mediaService.findByHash(hash);
        if (mediaEntity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        EntityTag etag = new EntityTag(hash);
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        return Response.ok((Object)mediaEntity.getData()).type(mediaEntity.getMimeType()).cacheControl(cc).tag(etag).build();
    }
}

