/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.NotifierResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.NotifierEntity;
import io.gravitee.rest.api.model.NotifierListItem;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.NotifierService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(name="Plugins")
public class NotifiersResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private NotifierService notifierService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List notifier plugins", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of notifiers", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=NotifierListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public Collection<NotifierListItem> getNotifiers(@QueryParam(value="expand") List<String> expand) {
        Stream<NotifierListItem> stream = this.notifierService.findAll().stream().map(this::convert);
        if (expand != null && !expand.isEmpty()) {
            Iterator<String> iterator = expand.iterator();
            while (iterator.hasNext()) {
                String s;
                switch (s = iterator.next()) {
                    case "schema": {
                        stream = stream.map(item -> {
                            item.setSchema(this.notifierService.getSchema(item.getId()));
                            return item;
                        });
                        break;
                    }
                }
            }
        }
        return stream.sorted(Comparator.comparing(NotifierListItem::getName)).collect(Collectors.toList());
    }

    @Path(value="{notifier}")
    public NotifierResource getNotifierResource() {
        return (NotifierResource)this.resourceContext.getResource(NotifierResource.class);
    }

    private NotifierListItem convert(NotifierEntity notifier) {
        NotifierListItem item = new NotifierListItem();
        item.setId(notifier.getId());
        item.setName(notifier.getName());
        item.setDescription(notifier.getDescription());
        item.setVersion(notifier.getVersion());
        return item;
    }
}

