/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.param;

import io.gravitee.rest.api.management.rest.resource.param.EventTypeListParam;
import io.gravitee.rest.api.management.rest.resource.param.ListStringParam;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;

public class EventSearchParam {
    @QueryParam(value="type")
    @Parameter(explode=Explode.FALSE, schema=@Schema(type="array"))
    private EventTypeListParam eventTypeListParam;
    @QueryParam(value="from")
    private Long from;
    @QueryParam(value="to")
    private Long to;
    @QueryParam(value="page")
    @DefaultValue(value="0")
    private Integer page;
    @QueryParam(value="size")
    @DefaultValue(value="10")
    private Integer size;
    @QueryParam(value="api_ids")
    @Parameter(explode=Explode.FALSE, schema=@Schema(type="array"))
    private ListStringParam apiIdsParam;

    public EventTypeListParam getEventTypeListParam() {
        return this.eventTypeListParam;
    }

    public void setEventTypeListParam(EventTypeListParam eventTypeListParam) {
        this.eventTypeListParam = eventTypeListParam;
    }

    public Long getFrom() {
        return this.from;
    }

    public void setFrom(Long from) {
        this.from = from;
    }

    public Long getTo() {
        return this.to;
    }

    public void setTo(Long to) {
        this.to = to;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public ListStringParam getApiIdsParam() {
        return this.apiIdsParam;
    }

    public void setApiIdsParam(ListStringParam apiIdsParam) {
        this.apiIdsParam = apiIdsParam;
    }

    public void validate() throws WebApplicationException {
        if (this.from == -1L) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'from' is not valid").build());
        }
        if (this.to == -1L) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'to' is not valid").build());
        }
        if (this.page == -1) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'page' is not valid").build());
        }
        if (this.size < 0 || this.size > 100) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'size' must be >= 0 and <= 100").build());
        }
        if (this.from >= this.to) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'from' query parameter value must be greater than 'to'").build());
        }
    }
}

