/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PathParam;
import java.util.Optional;

@Tag(name="Roles")
public class RoleUserResource
extends AbstractResource {
    @Inject
    private MembershipService membershipService;

    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete the role for a given user", description="User must have the MANAGEMENT_ROLE[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Role successfully removed"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.DELETE})})
    public void deleteRoleForUser(@PathParam(value="scope") RoleScope scope, @PathParam(value="role") String role, @PathParam(value="userId") String userId) {
        Optional roleToRemove = this.roleService.findByScopeAndName(scope, role, GraviteeContext.getCurrentOrganization());
        if (roleToRemove.isPresent()) {
            String roleId = ((RoleEntity)roleToRemove.get()).getId();
            if (RoleScope.ORGANIZATION.equals((Object)scope)) {
                this.membershipService.removeRole(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization(), MembershipMemberType.USER, userId, roleId);
            }
        }
    }
}

