/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.auth;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSAlgorithmFamilyJWSKeySelector;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.management.rest.resource.auth.AbstractAuthenticationResource;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.security.cookies.CookieGenerator;
import io.gravitee.rest.api.security.utils.AuthoritiesProvider;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Singleton
@Path(value="/auth/cockpit")
public class CockpitAuthenticationResource
extends AbstractAuthenticationResource {
    protected static final String ORG_CLAIM = "org";
    protected static final String KID = "cockpit";
    protected static final String REDIRECT_URI_CLAIM = "redirect_uri";
    protected static final String ENVIRONMENT_CLAIM = "env";
    protected static final String API_CLAIM = "api";
    private static final Logger LOGGER = LoggerFactory.getLogger(CockpitAuthenticationResource.class);
    private static final String COCKPIT_SOURCE = "cockpit";
    @Autowired
    protected MembershipService membershipService;
    @Autowired
    protected CookieGenerator cookieGenerator;
    private boolean enabled;
    private JWTProcessor<SecurityContext> jwtProcessor;
    @Autowired
    private UserService userService;
    @Autowired
    private Environment environment;
    @Autowired
    private AuthoritiesProvider authoritiesProvider;
    @Autowired
    private ApiSearchService apiSearchService;

    @PostConstruct
    public void afterPropertiesSet() {
        this.enabled = (Boolean)this.environment.getProperty("cockpit.enabled", Boolean.class, (Object)false);
        if (this.enabled) {
            try {
                RSAKey rsaKey = new RSAKey.Builder((RSAPublicKey)this.getPublicKey()).keyID("cockpit").build();
                JWSAlgorithmFamilyJWSKeySelector jwsKeySelector = new JWSAlgorithmFamilyJWSKeySelector(JWSAlgorithm.Family.RSA, (JWKSource)new ImmutableJWKSet(new JWKSet((JWK)rsaKey)));
                DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
                jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
                this.jwtProcessor = jwtProcessor;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to initialize cockpit filter", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Response tokenExchange(@QueryParam(value="token") String token, @Context HttpServletResponse httpResponse) {
        if (!this.enabled) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            JWTClaimsSet jwtClaimsSet = this.jwtProcessor.process(token, null);
            String organizationId = jwtClaimsSet.getStringClaim(ORG_CLAIM);
            GraviteeContext.setCurrentOrganization((String)organizationId);
            UserEntity user = this.userService.findBySource(GraviteeContext.getExecutionContext(), "cockpit", jwtClaimsSet.getSubject(), true);
            String environmentId = jwtClaimsSet.getStringClaim(ENVIRONMENT_CLAIM);
            Set authorities = this.authoritiesProvider.retrieveAuthorities(user.getId(), organizationId, environmentId);
            UserDetails userDetails = new UserDetails(user.getId(), "", (Collection)authorities);
            userDetails.setOrganizationId(user.getOrganizationId());
            userDetails.setEmail(user.getEmail());
            SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, null, (Collection)authorities));
            super.connectUser(user, httpResponse);
            String apiCrossId = jwtClaimsSet.getStringClaim(API_CLAIM);
            String apiId = Optional.ofNullable(apiCrossId).flatMap(crossId -> this.apiSearchService.findIdByEnvironmentIdAndCrossId(environmentId, crossId)).orElse(null);
            String url = String.format("%s?organization=%s/#!/environments/%s/%s", jwtClaimsSet.getStringClaim(REDIRECT_URI_CLAIM), jwtClaimsSet.getStringClaim(ORG_CLAIM), environmentId, apiId == null ? "" : URLEncoder.encode(String.format("apis/%s/portal", apiId), StandardCharsets.UTF_8));
            Response response = Response.temporaryRedirect((URI)new URI(url)).build();
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred when trying to log user using cockpit.", (Throwable)e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            GraviteeContext.cleanContext();
        }
    }

    private Key getPublicKey() throws Exception {
        KeyStore trustStore = this.loadTrustStore();
        Certificate cert = trustStore.getCertificate(this.environment.getProperty("cockpit.keystore.key.alias", "cockpit-client"));
        return cert.getPublicKey();
    }

    private KeyStore loadTrustStore() throws Exception {
        KeyStore keystore = KeyStore.getInstance(this.environment.getProperty("cockpit.keystore.type"));
        try (InputStream is = new File(this.environment.getProperty("cockpit.keystore.path")).toURI().toURL().openStream();){
            String password = this.environment.getProperty("cockpit.keystore.password");
            keystore.load(is, null == password ? null : password.toCharArray());
        }
        return keystore;
    }
}

