/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.UrlPictureEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.theme.ThemeEntity;
import io.gravitee.rest.api.model.theme.UpdateThemeEntity;
import io.gravitee.rest.api.service.ThemeService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.net.URI;

@Tag(name="Themes")
public class ThemeResource
extends AbstractResource {
    @Inject
    private ThemeService themeService;
    @PathParam(value="themeId")
    @Parameter(name="themeId", required=true)
    private String themeId;

    @GET
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.READ})})
    public ThemeEntity getTheme() {
        return this.themeService.findById(GraviteeContext.getExecutionContext(), this.themeId);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.UPDATE})})
    public ThemeEntity updateTheme(@Valid @NotNull UpdateThemeEntity theme) {
        theme.setId(this.themeId);
        return this.themeService.update(GraviteeContext.getExecutionContext(), theme);
    }

    @Path(value="/reset")
    @POST
    @Produces(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.UPDATE})})
    public ThemeEntity resetTheme() {
        return this.themeService.resetToDefaultTheme(GraviteeContext.getExecutionContext(), this.themeId);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_THEME, acls={RolePermissionAction.DELETE})})
    public void deleteTheme() {
        this.themeService.delete(GraviteeContext.getExecutionContext(), this.themeId);
    }

    @GET
    @Path(value="/logo")
    public Response getThemeLogo(@Context Request request) {
        return this.buildPictureResponse(this.themeService.getLogo(GraviteeContext.getExecutionContext(), this.themeId), request);
    }

    @GET
    @Path(value="/optionalLogo")
    public Response getLogoLight(@Context Request request) {
        return this.buildPictureResponse(this.themeService.getOptionalLogo(GraviteeContext.getExecutionContext(), this.themeId), request);
    }

    @GET
    @Path(value="/favicon")
    public Response getFavicon(@Context Request request) {
        return this.buildPictureResponse(this.themeService.getFavicon(GraviteeContext.getExecutionContext(), this.themeId), request);
    }

    @GET
    @Path(value="/backgroundImage")
    public Response getThemeBackground(@Context Request request) {
        return this.buildPictureResponse(this.themeService.getBackgroundImage(GraviteeContext.getExecutionContext(), this.themeId), request);
    }

    private Response buildPictureResponse(PictureEntity picture, @Context Request request) {
        if (picture == null) {
            return Response.ok().build();
        }
        if (picture instanceof UrlPictureEntity) {
            return Response.temporaryRedirect((URI)URI.create(((UrlPictureEntity)picture).getUrl())).build();
        }
        CacheControl cc = new CacheControl();
        cc.setNoTransform(true);
        cc.setMustRevalidate(false);
        cc.setNoCache(false);
        cc.setMaxAge(86400);
        InlinePictureEntity image = (InlinePictureEntity)picture;
        EntityTag etag = new EntityTag(Integer.toString(new String(image.getContent()).hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(etag);
        if (builder != null) {
            return builder.cacheControl(cc).build();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(image.getContent(), 0, image.getContent().length);
        return Response.ok().entity((Object)baos).cacheControl(cc).tag(etag).type(image.getType()).build();
    }
}

