/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.PolicyEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.platform.plugin.SchemaDisplayFormat;
import io.gravitee.rest.api.service.PolicyService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;

@Tag(name="Plugins")
public class PolicyResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private PolicyService policyService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a policy", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public PolicyEntity getPolicy(@PathParam(value="policy") String policy) {
        return (PolicyEntity)this.policyService.findById(policy);
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @Operation(summary="Get a policy's schema", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getPolicySchema(@PathParam(value="policy") String policy) {
        this.policyService.findById(policy);
        return this.policyService.getSchema(policy, SchemaDisplayFormat.GV_SCHEMA_FORM);
    }

    @GET
    @Path(value="icon")
    @Produces(value={"text/plain"})
    @Operation(summary="Get a policy's icon", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getPolicyIcon(@PathParam(value="policy") String policy) {
        this.policyService.findById(policy);
        return this.policyService.getIcon(policy);
    }

    @GET
    @Path(value="documentation")
    @Produces(value={"text/plain"})
    @Operation(summary="Get a policy's documentation", description="User must have the MANAGEMENT_API[READ] permission to use this service")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_API, acls={RolePermissionAction.READ})})
    public String getPolicyDoc(@PathParam(value="policy") String policy) {
        this.policyService.findById(policy);
        return this.policyService.getDocumentation(policy);
    }
}

