/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.MonitoringResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.InstanceEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.InstanceService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;

@Tag(name="Gateway")
public class InstanceResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private InstanceService instanceService;
    @PathParam(value="instance")
    private String instance;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a gateway instance")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_INSTANCE, acls={RolePermissionAction.READ})})
    public InstanceEntity getInstance() {
        return this.instanceService.findByEvent(GraviteeContext.getExecutionContext(), this.instance);
    }

    @Path(value="monitoring/{gatewayId}")
    public MonitoringResource getMonitoringResource() {
        return (MonitoringResource)this.resourceContext.getResource(MonitoringResource.class);
    }
}

