/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationMetadataEntity;
import io.gravitee.rest.api.model.NewApplicationMetadataEntity;
import io.gravitee.rest.api.model.UpdateApplicationMetadataEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.ApplicationMetadataService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;

@Tag(name="Application Metadata")
public class ApplicationMetadataResource
extends AbstractResource {
    @Inject
    private ApplicationMetadataService metadataService;
    @PathParam(value="application")
    @Parameter(name="application", hidden=true)
    private String application;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List metadata for an application", description="User must have the APPLICATION_METADATA[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of metadata for an application", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApplicationMetadataEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_METADATA, acls={RolePermissionAction.READ})})
    public List<ApplicationMetadataEntity> getApplicationMetadatas() {
        return this.metadataService.findAllByApplication(this.application);
    }

    @GET
    @Path(value="{metadata}")
    @Produces(value={"application/json"})
    @Operation(summary="A metadata for an application and metadata id", description="User must have the APPLICATION_METADATA[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A metadata", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationMetadataEntity.class))}), @ApiResponse(responseCode="404", description="Metadata not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_METADATA, acls={RolePermissionAction.READ})})
    public ApplicationMetadataEntity getApplicationMetadata(@PathParam(value="metadata") String metadata) {
        return this.metadataService.findByIdAndApplication(metadata, this.application);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an application metadata", description="User must have the APPLICATION_METADATA[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Application metadata successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationMetadataEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_METADATA, acls={RolePermissionAction.CREATE})})
    public Response createApplicationMetadata(@Valid @NotNull NewApplicationMetadataEntity metadata) {
        metadata.setApplicationId(this.application);
        ApplicationMetadataEntity applicationMetadataEntity = this.metadataService.create(GraviteeContext.getExecutionContext(), metadata);
        return Response.created((URI)this.getLocationHeader(applicationMetadataEntity.getKey())).entity((Object)applicationMetadataEntity).build();
    }

    @PUT
    @Path(value="{metadata}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an application metadata", description="User must have the APPLICATION_METADATA[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Updated application metadata", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationMetadataEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_METADATA, acls={RolePermissionAction.UPDATE})})
    public Response updateApplicationMetadata(@PathParam(value="metadata") String metadataPathParam, @Valid @NotNull UpdateApplicationMetadataEntity metadata) {
        metadata.setApplicationId(this.application);
        return Response.ok((Object)this.metadataService.update(GraviteeContext.getExecutionContext(), metadata)).build();
    }

    @DELETE
    @Path(value="{metadata}")
    @Operation(summary="Delete a metadata", description="User must have the APPLICATION_METADATA[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Metadata successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_METADATA, acls={RolePermissionAction.DELETE})})
    public Response deleteApplicationMetadata(@PathParam(value="metadata") String metadata) {
        this.metadataService.delete(GraviteeContext.getExecutionContext(), metadata, this.application);
        return Response.noContent().build();
    }
}

