/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.filter;

import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedAccessException;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.Provider;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

@Provider
@Priority(value=200)
public class PermissionsFilter
implements ContainerRequestFilter {
    @Context
    protected ResourceInfo resourceInfo;
    @Inject
    private SecurityContext securityContext;
    @Inject
    private PermissionService permissionService;

    public void filter(ContainerRequestContext requestContext) {
        this.findRequiredPermissions().ifPresent(requiredPermissions -> {
            this.mustBeAuthenticated();
            this.filter((Permissions)requiredPermissions, requestContext, GraviteeContext.getExecutionContext());
        });
    }

    protected void filter(Permissions permissions, ContainerRequestContext requestContext, ExecutionContext executionContext) {
        Stream.of(permissions.value()).filter((? super T permission) -> this.hasPermission((Permission)permission, requestContext, executionContext)).findAny().orElseThrow(ForbiddenAccessException::new);
    }

    private boolean hasPermission(Permission permission, ContainerRequestContext requestContext, ExecutionContext executionContext) {
        switch (permission.value().getScope()) {
            case ORGANIZATION: {
                return this.hasPermission(executionContext, permission, executionContext.getOrganizationId());
            }
            case ENVIRONMENT: {
                return executionContext.hasEnvironmentId() && this.hasPermission(executionContext, permission, executionContext.getEnvironmentId());
            }
            case APPLICATION: {
                return this.hasPermission(executionContext, permission, this.getApplicationId(requestContext));
            }
            case API: {
                return this.hasPermission(executionContext, permission, this.getApiId(requestContext));
            }
            case GROUP: {
                return this.hasPermission(executionContext, permission, this.getGroupId(requestContext));
            }
        }
        return false;
    }

    private boolean hasPermission(ExecutionContext executionContext, Permission permission, String referenceId) {
        return this.permissionService.hasPermission(executionContext, permission.value(), referenceId, permission.acls());
    }

    private String getGroupId(ContainerRequestContext requestContext) {
        return this.getId("group", requestContext);
    }

    private String getApiId(ContainerRequestContext requestContext) {
        return this.getId("api", requestContext);
    }

    private String getApplicationId(ContainerRequestContext requestContext) {
        return this.getId("application", requestContext);
    }

    private String getId(String key, ContainerRequestContext requestContext) {
        List pathParams = (List)requestContext.getUriInfo().getPathParameters().get((Object)key);
        if (pathParams != null) {
            return (String)pathParams.iterator().next();
        }
        List queryParams = (List)requestContext.getUriInfo().getQueryParameters().get((Object)key);
        if (queryParams != null) {
            return (String)queryParams.iterator().next();
        }
        return null;
    }

    private Optional<Permissions> findRequiredPermissions() {
        return Optional.ofNullable(this.resourceInfo.getResourceMethod().getDeclaredAnnotation(Permissions.class)).or(() -> Optional.ofNullable(this.resourceInfo.getResourceClass().getDeclaredAnnotation(Permissions.class)));
    }

    private void mustBeAuthenticated() {
        Principal principal = this.securityContext.getUserPrincipal();
        if (principal == null) {
            throw new UnauthorizedAccessException();
        }
    }
}

