/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.portal;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.model.configuration.identity.SocialIdentityProviderEntity;
import io.gravitee.rest.api.service.SocialIdentityProviderService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.stream.Collectors;

@Tags(value={@Tag(name="Portal"), @Tag(name="Authentication"), @Tag(name="Identity Providers")})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SocialIdentityProvidersResource
extends AbstractResource {
    @Inject
    private SocialIdentityProviderService socialIdentityProviderService;
    @Inject
    private IdentityProviderActivationService identityProviderActivationService;

    @GET
    @Operation(summary="Get the list of social identity providers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List social identity providers", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SocialIdentityProviderEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<SocialIdentityProviderEntity> getSocialIdentityProviders() {
        return this.socialIdentityProviderService.findAll(GraviteeContext.getExecutionContext(), new IdentityProviderActivationService.ActivationTarget(GraviteeContext.getCurrentOrganization(), IdentityProviderActivationReferenceType.ORGANIZATION)).stream().sorted((idp1, idp2) -> String.CASE_INSENSITIVE_ORDER.compare(idp1.getName(), idp2.getName())).collect(Collectors.toList());
    }
}

