/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.EnvironmentResource;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.EnvironmentPermissionsEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EnvironmentsResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private EnvironmentService environmentService;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List available environments for current user organization")
    public Collection<EnvironmentEntity> getEnvironments() {
        return this.environmentService.findByUser(GraviteeContext.getCurrentOrganization(), this.getAuthenticatedUserOrNull());
    }

    @Path(value="{envId}")
    public EnvironmentResource getEnvironmentResource(@PathParam(value="envId") @Parameter(name="envId", required=true, description="The ID of the environment", schema=@Schema(defaultValue="DEFAULT")) String envId) {
        return (EnvironmentResource)this.resourceContext.getResource(EnvironmentResource.class);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/permissions")
    @Operation(summary="List available environments with their permissions for current user organization")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Current user permissions on its environments", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EnvironmentPermissionsEntity.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public List<EnvironmentPermissionsEntity> getEnvironmentsPermissions(@Parameter(description="To filter on environment id or hrid") @QueryParam(value="idOrHrid") String id) {
        List environments = this.environmentService.findByUserAndIdOrHrid(GraviteeContext.getCurrentOrganization(), this.getAuthenticatedUserOrNull(), id);
        return environments.stream().map(environment -> {
            Map permissions = new HashMap();
            if (this.isAuthenticated()) {
                String username = this.getAuthenticatedUser();
                permissions = this.membershipService.getUserMemberPermissions(GraviteeContext.getExecutionContext(), environment, username);
            }
            EnvironmentPermissionsEntity environmentPermissions = new EnvironmentPermissionsEntity();
            environmentPermissions.setId(environment.getId());
            environmentPermissions.setName(environment.getName());
            environmentPermissions.setHrids(environment.getHrids());
            environmentPermissions.setPermissions(permissions);
            return environmentPermissions;
        }).collect(Collectors.toList());
    }
}

