/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.provider;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.management.rest.provider.AbstractExceptionMapper;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

public class ConstraintValidationExceptionMapper
extends AbstractExceptionMapper<ConstraintViolationException> {
    public Response toResponse(ConstraintViolationException cve) {
        Response.Status error = Response.Status.BAD_REQUEST;
        return Response.status((Response.Status)error).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ConstraintValidationError(cve)).build();
    }

    private String prepareMessage(ConstraintViolationException exception) {
        StringBuilder message = new StringBuilder();
        for (ConstraintViolation cv : exception.getConstraintViolations()) {
            message.append(cv.getMessage());
        }
        return message.toString();
    }

    static class ConstraintValidationError {
        private final String message;
        private final String path;
        @JsonProperty(value="invalid_value")
        private final Object invalidValue;

        ConstraintValidationError(ConstraintViolationException cve) {
            ConstraintViolation violation = (ConstraintViolation)cve.getConstraintViolations().iterator().next();
            this.message = violation.getMessage();
            this.path = violation.getPropertyPath().toString();
            this.invalidValue = violation.getInvalidValue();
        }

        public String getMessage() {
            return this.message;
        }

        public String getPath() {
            return this.path;
        }

        public Object getInvalidValue() {
            return this.invalidValue;
        }
    }
}

