/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.model;

import io.gravitee.rest.api.model.common.PageableImpl;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;

public class Pageable {
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int DEFAULT_PAGE_NUMBER = 1;
    @QueryParam(value="size")
    @DefaultValue(value="20")
    @Min(value=1L, message="Page size should not be lesser than 1")
    @Max(value=100L, message="Page size should not be higher than 100")
    private @Min(value=1L, message="Page size should not be lesser than 1") @Max(value=100L, message="Page size should not be higher than 100") int size = 20;
    @QueryParam(value="page")
    @DefaultValue(value="1")
    @Min(value=1L, message="Page number should not be lesser than 1")
    private @Min(value=1L, message="Page number should not be lesser than 1") int page = 1;

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public io.gravitee.rest.api.model.common.Pageable toPageable() {
        return new PageableImpl(this.getPage(), this.getSize());
    }
}

