/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.filter;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.security.Principal;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Provider
@PreMatching
@Priority(value=100)
public class SecurityContextFilter
implements ContainerRequestFilter {
    public void filter(final ContainerRequestContext requestContext) throws IOException {
        requestContext.setSecurityContext(new SecurityContext(){

            public Principal getUserPrincipal() {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                return authentication instanceof AnonymousAuthenticationToken ? null : authentication;
            }

            public boolean isUserInRole(String role) {
                return SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equalsIgnoreCase(role));
            }

            public boolean isSecure() {
                return requestContext.getUriInfo().getRequestUri().getScheme().equalsIgnoreCase("https");
            }

            public String getAuthenticationScheme() {
                return requestContext.getUriInfo().getRequestUri().getScheme();
            }
        });
    }
}

