/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.gravitee.rest.api.management.rest.resource.param.Aggregation;
import io.gravitee.rest.api.management.rest.resource.param.AggregationsParam;
import io.gravitee.rest.api.management.rest.resource.param.AnalyticsType;
import io.gravitee.rest.api.management.rest.resource.param.Order;
import io.gravitee.rest.api.management.rest.resource.param.Range;
import io.gravitee.rest.api.management.rest.resource.param.RangesParam;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.List;

public class AnalyticsParam {
    @QueryParam(value="from")
    @Parameter(description="Timestamp used to define the start date of the time window to query")
    private long from;
    @QueryParam(value="to")
    @Parameter(description="Timestamp used to define the end date of the time window to query")
    private long to;
    @QueryParam(value="interval")
    @Parameter(description="The time interval when getting histogram data (in milliseconds)", example="600000")
    private long interval;
    @QueryParam(value="query")
    @Parameter(description="The Lucene query used to filter data", example="api:xxxx-xxxx-xxxx-xxxx AND plan:yyyy-yyyy-yyyy-yyyy AND host:\"demo.gravitee.io\" AND path:/test")
    private String query;
    @QueryParam(value="field")
    @Parameter(description="The field to query when doing `group_by` queries")
    private String field;
    @QueryParam(value="size")
    @Parameter(description="The number of data to retrieve")
    private int size;
    @QueryParam(value="type")
    @Parameter(description="The type of data to retrieve", required=true)
    private AnalyticsType type;
    @QueryParam(value="ranges")
    @Parameter(description="Ranges allows you to group field's data. Mainly used to group HTTP statuses code with `group_by` queries", explode=Explode.FALSE, schema=@Schema(type="array"), example="100:199,200:299,300:399,400:499,500:599")
    private RangesParam ranges;
    @QueryParam(value="aggs")
    @Parameter(description="Aggregations are used when doing `date_histo` queries and allows you to group field's data. Mainly used to group HTTP statuses code", explode=Explode.FALSE, schema=@Schema(type="array"), example="avg:response-time,avg:api-response-time")
    private AggregationsParam aggregations;
    @JsonIgnore
    private Order order;

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getTo() {
        return this.to;
    }

    public void setTo(long to) {
        this.to = to;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public AnalyticsType getType() {
        return this.type;
    }

    public void setType(AnalyticsType type) {
        this.type = type;
    }

    public List<Range> getRanges() {
        return this.ranges == null ? null : this.ranges.getValues();
    }

    public List<Aggregation> getAggregations() {
        return this.aggregations == null ? null : this.aggregations.getValues();
    }

    @QueryParam(value="order")
    @Parameter(description="The field used to sort results. Can be asc or desc (prefix with minus '-') ", example="order:-response-time")
    public void setOrder(String param) {
        if (param != null) {
            this.order = Order.parse(param);
        }
    }

    public Order getOrder() {
        return this.order;
    }

    public void validate() throws WebApplicationException {
        if (this.type == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'type' is not valid").build());
        }
        if (this.from == -1L) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'from' is not valid").build());
        }
        if (this.to == -1L) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'to' is not valid").build());
        }
        if (this.interval == -1L) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'interval' is not valid").build());
        }
        if (this.interval < 1000L || this.interval > 1000000000L) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Query parameter 'interval' is not valid. 'interval' must be >= 1000 and <= 1000000000").build());
        }
        if (this.from >= this.to) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'from' query parameter value must be greater than 'to'").build());
        }
        if (this.type == AnalyticsType.GROUP_BY && (this.field == null || this.field.trim().isEmpty())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'field' query parameter is required for 'group_by' request").build());
        }
    }
}

