/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource.organization;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.organization.RoleUsersResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateRoleEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Optional;

@Tag(name="Roles")
public class RoleResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private RoleService roleService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get a role", description="User must have the MANAGEMENT_ROLE[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="A role", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleEntity.class))}), @ApiResponse(responseCode="404", description="Role not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.READ})})
    public RoleEntity getRole(@PathParam(value="scope") RoleScope scope, @PathParam(value="role") String role) {
        Optional optRole = this.roleService.findByScopeAndName(scope, role, GraviteeContext.getCurrentOrganization());
        if (optRole.isPresent()) {
            return (RoleEntity)optRole.get();
        }
        throw new RoleNotFoundException(scope.name() + "_" + role);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a role", description="User must have the MANAGEMENT_ROLE[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Role successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleEntity.class))}), @ApiResponse(responseCode="404", description="Role not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.UPDATE})})
    public RoleEntity updateRole(@PathParam(value="scope") RoleScope scope, @PathParam(value="role") String role, @Valid @NotNull UpdateRoleEntity entity) {
        return this.roleService.update(GraviteeContext.getExecutionContext(), entity);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Operation(summary="Delete a role", description="User must have the MANAGEMENT_ROLE[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Role successfully deleted", content={@Content(mediaType="application/json", schema=@Schema(implementation=RoleEntity.class))}), @ApiResponse(responseCode="404", description="Role not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ORGANIZATION_ROLE, acls={RolePermissionAction.DELETE})})
    public void deleteRole(@PathParam(value="scope") RoleScope scope, @PathParam(value="role") String role) {
        this.roleService.findByScopeAndName(scope, role, GraviteeContext.getCurrentOrganization()).ifPresent(roleToDelete -> this.roleService.delete(GraviteeContext.getExecutionContext(), roleToDelete.getId()));
    }

    @Path(value="/users")
    public RoleUsersResource getRoleUsersResource() {
        return (RoleUsersResource)this.resourceContext.getResource(RoleUsersResource.class);
    }
}

