/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.GroupInvitationsResource;
import io.gravitee.rest.api.management.rest.resource.GroupMembersResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.UpdateGroupEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Tag(name="Groups")
public class GroupResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private GroupService groupService;
    @PathParam(value="group")
    @Parameter(name="group", required=true)
    private String group;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a group")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Group definition", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ})})
    public GroupEntity getGroup() {
        return this.groupService.findById(GraviteeContext.getExecutionContext(), this.group);
    }

    @DELETE
    @Operation(summary="Delete an existing group")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Group successfully deleted"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.DELETE})})
    public Response deleteGroup() {
        this.checkRights();
        this.groupService.delete(GraviteeContext.getExecutionContext(), this.group);
        return Response.noContent().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an existing group")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Group successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE}), @Permission(value=RolePermission.GROUP_MEMBER, acls={RolePermissionAction.UPDATE})})
    public GroupEntity updateGroup(@Parameter(name="group", required=true) @Valid @NotNull UpdateGroupEntity updateGroupEntity) {
        GroupEntity groupEntity = this.checkRights();
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (!this.permissionService.hasPermission(executionContext, RolePermission.ENVIRONMENT_GROUP, GraviteeContext.getCurrentEnvironment(), new RolePermissionAction[]{RolePermissionAction.CREATE, RolePermissionAction.UPDATE, RolePermissionAction.DELETE})) {
            updateGroupEntity.setMaxInvitation(groupEntity.getMaxInvitation());
            updateGroupEntity.setLockApiRole(groupEntity.isLockApiRole());
            updateGroupEntity.setLockApplicationRole(groupEntity.isLockApplicationRole());
            updateGroupEntity.setSystemInvitation(groupEntity.isSystemInvitation());
            updateGroupEntity.setEmailInvitation(groupEntity.isEmailInvitation());
            if (groupEntity.isLockApiRole()) {
                updateGroupEntity.getRoles().put(RoleScope.API, (String)groupEntity.getRoles().get(RoleScope.API));
            }
            if (groupEntity.isLockApplicationRole()) {
                updateGroupEntity.getRoles().put(RoleScope.APPLICATION, (String)groupEntity.getRoles().get(RoleScope.APPLICATION));
            }
        }
        return this.groupService.update(executionContext, this.group, updateGroupEntity);
    }

    @GET
    @Path(value="/memberships")
    @Produces(value={"application/json"})
    @Operation(summary="List APIs or applications linked to this group")
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.READ})})
    public Response getGroupMemberships(@QueryParam(value="type") String type) {
        if ("api".equalsIgnoreCase(type)) {
            return Response.ok((Object)this.groupService.getApis(GraviteeContext.getCurrentEnvironment(), this.group)).build();
        }
        if ("application".equalsIgnoreCase(type)) {
            return Response.ok((Object)this.groupService.getApplications(this.group)).build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/memberships")
    @Produces(value={"application/json"})
    @Operation(summary="Associate a group to existing APIs or Applications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Group successfully updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=GroupEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_GROUP, acls={RolePermissionAction.UPDATE})})
    public GroupEntity addGroupMember(@QueryParam(value="type") String type) {
        GroupEntity groupEntity = this.checkRights();
        this.groupService.associate(GraviteeContext.getExecutionContext(), this.group, type);
        return groupEntity;
    }

    private GroupEntity checkRights() {
        GroupEntity groupEntity = this.getGroup();
        if (!groupEntity.isManageable()) {
            throw new ForbiddenAccessException();
        }
        return groupEntity;
    }

    @Path(value="members")
    public GroupMembersResource groupMembersResource() {
        return (GroupMembersResource)this.resourceContext.getResource(GroupMembersResource.class);
    }

    @Path(value="invitations")
    public GroupInvitationsResource groupInvitationsResource() {
        return (GroupInvitationsResource)this.resourceContext.getResource(GroupInvitationsResource.class);
    }
}

