/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.model.Subscription;
import io.gravitee.rest.api.management.rest.model.wrapper.SubscriptionEntityPageResult;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.ApiSubscriptionResource;
import io.gravitee.rest.api.management.rest.resource.param.ListStringParam;
import io.gravitee.rest.api.management.rest.resource.param.ListSubscriptionStatusParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.NewSubscriptionConfigurationEntity;
import io.gravitee.rest.api.model.NewSubscriptionEntity;
import io.gravitee.rest.api.model.ProcessSubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.subscription.SubscriptionMetadataQuery;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.gravitee.rest.api.validator.CustomApiKey;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Tag(name="API Subscriptions")
public class ApiSubscriptionsResource
extends AbstractResource {
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private PlanSearchService planSearchService;
    @Context
    private ResourceContext resourceContext;
    @Inject
    private UserService userService;
    @Inject
    private ApiKeyService apiKeyService;
    @Inject
    private ParameterService parameterService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List subscriptions for the API", description="User must have the READ_SUBSCRIPTION permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Paged result of API's subscriptions", content={@Content(mediaType="application/json", schema=@Schema(implementation=SubscriptionEntityPageResult.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public SubscriptionEntityPageResult getApiSubscriptions(@BeanParam SubscriptionParam subscriptionParam, @Valid @BeanParam Pageable pageable, @Parameter(description="Expansion of data to return in subscriptions", array=@ArraySchema(schema=@Schema(allowableValues={"keys", "security"}))) @QueryParam(value="expand") List<String> expand) {
        SubscriptionQuery subscriptionQuery = subscriptionParam.toQuery();
        subscriptionQuery.setApi(this.api);
        boolean expandApiKeys = expand != null && expand.contains("keys");
        boolean expandPlanSecurity = expand != null && expand.contains("security");
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        Page subscriptions = this.subscriptionService.search(executionContext, subscriptionQuery, pageable.toPageable(), expandApiKeys, expandPlanSecurity);
        SubscriptionEntityPageResult result = new SubscriptionEntityPageResult((Page<SubscriptionEntity>)subscriptions, pageable.getSize());
        SubscriptionMetadataQuery subscriptionMetadataQuery = new SubscriptionMetadataQuery(executionContext.getOrganizationId(), executionContext.getEnvironmentId(), (Collection)subscriptions.getContent()).withApis(true).withApplications(true).withPlans(true);
        result.setMetadata(this.subscriptionService.getMetadata(executionContext, subscriptionMetadataQuery).toMap());
        return result;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Subscribe to a plan", description="User must have the MANAGE_SUBSCRIPTIONS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Subscription successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="Bad custom API Key format or custom API Key definition disabled"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.CREATE})})
    public Response createSubscriptionToApi(@Parameter(name="application", required=true) @NotNull @QueryParam(value="application") String application, @Parameter(name="plan", required=true) @NotNull @QueryParam(value="plan") String plan, @Parameter(name="customApiKey") @CustomApiKey @QueryParam(value="customApiKey") String customApiKey, @Valid NewSubscriptionConfigurationEntity newSubscriptionConfigurationEntity) {
        SubscriptionEntity subscription;
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (StringUtils.isNotEmpty((CharSequence)customApiKey) && !this.parameterService.findAsBoolean(executionContext, Key.PLAN_SECURITY_APIKEY_CUSTOM_ALLOWED, ParameterReferenceType.ENVIRONMENT)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"You are not allowed to provide a custom API Key").build();
        }
        NewSubscriptionEntity newSubscriptionEntity = new NewSubscriptionEntity(plan, application);
        if (newSubscriptionConfigurationEntity != null) {
            newSubscriptionEntity.setConfiguration(newSubscriptionConfigurationEntity.getConfiguration());
            newSubscriptionEntity.setMetadata(newSubscriptionConfigurationEntity.getMetadata());
        }
        if ((subscription = this.subscriptionService.create(executionContext, newSubscriptionEntity, customApiKey)).getStatus() == SubscriptionStatus.PENDING) {
            ProcessSubscriptionEntity process = new ProcessSubscriptionEntity();
            process.setId(subscription.getId());
            process.setAccepted(true);
            process.setStartingAt(new Date());
            process.setCustomApiKey(customApiKey);
            subscription = this.subscriptionService.process(executionContext, process, this.getAuthenticatedUser());
        }
        return Response.created((URI)this.getRequestUriBuilder().path(subscription.getId()).replaceQueryParam("application", null).replaceQueryParam("plan", null).build(new Object[0])).entity((Object)this.convert(executionContext, subscription)).build();
    }

    @GET
    @Path(value="export")
    @Produces(value={"text/csv"})
    @Operation(summary="Export API logs as CSV")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API logs as CSV", content={@Content(mediaType="text/csv", schema=@Schema(type="string"))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_LOG, acls={RolePermissionAction.READ})})
    public Response exportApiSubscriptionsLogsAsCSV(@BeanParam SubscriptionParam subscriptionParam, @Valid @BeanParam Pageable pageable) {
        SubscriptionEntityPageResult subscriptions = this.getApiSubscriptions(subscriptionParam, pageable, null);
        return Response.ok((Object)this.subscriptionService.exportAsCsv(subscriptions.getData(), subscriptions.getMetadata())).header("Content-Disposition", (Object)String.format("attachment;filename=subscriptions-%s-%s.csv", this.api, System.currentTimeMillis())).build();
    }

    @GET
    @Path(value="_canCreate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Check a subscription can be created with given API Key, and application", description="User must have the API_SUBSCRIPTION:READ permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API Key creation successfully checked", content={@Content(mediaType="application/json", schema=@Schema(implementation=Boolean.class))}), @ApiResponse(responseCode="400", description="Bad API Key parameter"), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public Response verifyApiKeyCreation(@Parameter(name="key", required=true) @CustomApiKey @NotNull @QueryParam(value="key") String key, @Parameter(name="application", required=true) @NotNull @QueryParam(value="application") String application) {
        boolean canCreate = this.apiKeyService.canCreate(GraviteeContext.getExecutionContext(), key, this.api, application);
        return Response.ok((Object)canCreate).build();
    }

    @Path(value="{subscription}")
    public ApiSubscriptionResource getApiSubscriptionResource() {
        return (ApiSubscriptionResource)this.resourceContext.getResource(ApiSubscriptionResource.class);
    }

    private Subscription convert(ExecutionContext executionContext, SubscriptionEntity subscriptionEntity) {
        Subscription subscription = new Subscription();
        subscription.setId(subscriptionEntity.getId());
        subscription.setCreatedAt(subscriptionEntity.getCreatedAt());
        subscription.setUpdatedAt(subscriptionEntity.getUpdatedAt());
        subscription.setStartingAt(subscriptionEntity.getStartingAt());
        subscription.setEndingAt(subscriptionEntity.getEndingAt());
        subscription.setProcessedAt(subscriptionEntity.getProcessedAt());
        subscription.setProcessedBy(subscriptionEntity.getProcessedBy());
        subscription.setReason(subscriptionEntity.getReason());
        subscription.setStatus(subscriptionEntity.getStatus());
        subscription.setSubscribedBy(new Subscription.User(subscriptionEntity.getSubscribedBy(), this.userService.findById(executionContext, subscriptionEntity.getSubscribedBy()).getDisplayName()));
        subscription.setMetadata(subscriptionEntity.getMetadata());
        subscription.setConfiguration(subscriptionEntity.getConfiguration());
        GenericPlanEntity plan = this.planSearchService.findById(executionContext, subscriptionEntity.getPlan());
        subscription.setPlan(new Subscription.Plan(plan.getId(), plan.getName()));
        ApplicationEntity application = this.applicationService.findById(executionContext, subscriptionEntity.getApplication());
        subscription.setApplication(new Subscription.Application(application.getId(), application.getName(), application.getType(), application.getDescription(), application.getDomain(), new Subscription.User(application.getPrimaryOwner().getId(), application.getPrimaryOwner().getDisplayName()), application.getApiKeyMode()));
        subscription.setClosedAt(subscriptionEntity.getClosedAt());
        return subscription;
    }

    private static class SubscriptionParam {
        @QueryParam(value="plan")
        @Parameter(description="plan", explode=Explode.FALSE, schema=@Schema(type="array"))
        private ListStringParam plans;
        @QueryParam(value="application")
        @Parameter(description="application", explode=Explode.FALSE, schema=@Schema(type="array"))
        private ListStringParam applications;
        @QueryParam(value="status")
        @DefaultValue(value="ACCEPTED")
        @Parameter(description="Comma separated list of Subscription status, default is ACCEPTED", explode=Explode.FALSE, schema=@Schema(type="array"))
        private ListSubscriptionStatusParam status;
        @QueryParam(value="api_key")
        private String apiKey;

        private SubscriptionParam() {
        }

        public ListStringParam getPlans() {
            return this.plans;
        }

        public void setPlans(ListStringParam plans) {
            this.plans = plans;
        }

        public ListStringParam getApplications() {
            return this.applications;
        }

        public void setApplications(ListStringParam applications) {
            this.applications = applications;
        }

        public ListSubscriptionStatusParam getStatus() {
            return this.status;
        }

        public void setStatus(ListSubscriptionStatusParam status) {
            this.status = status;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        private SubscriptionQuery toQuery() {
            SubscriptionQuery query = new SubscriptionQuery();
            query.setPlans((Collection)this.plans);
            query.setStatuses((Collection)this.status);
            query.setApplications((Collection)this.applications);
            query.setApiKey(this.apiKey);
            return query;
        }
    }
}

