/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.management.rest.model.Pageable;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.application.ApplicationExcludeFilter;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.application.ApplicationQuery;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Tag(name="API Subscriptions")
public class ApiSubscribersResource
extends AbstractResource {
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private ApplicationService applicationService;
    @Context
    private ResourceContext resourceContext;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="List subscribers for the API", description="User must have the MANAGE_SUBSCRIPTIONS permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Paged result of API subscribers", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ApplicationListItem.class)))}), @ApiResponse(responseCode="500", description="Internal server error")})
    public Collection<ApplicationListItem> getApiSubscribers(@QueryParam(value="query") String query, @QueryParam(value="exclude") List<ApplicationExcludeFilter> exclude, @Valid @BeanParam Pageable pageable) {
        SortableImpl sortable;
        Page subscribersApplicationPage;
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        if (!this.hasPermission(executionContext, RolePermission.API_SUBSCRIPTION, this.api, RolePermissionAction.READ) && !this.hasPermission(executionContext, RolePermission.API_LOG, this.api, RolePermissionAction.READ)) {
            throw new ForbiddenAccessException();
        }
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setApi(this.api);
        Collection subscriptions = this.subscriptionService.search(executionContext, subscriptionQuery);
        Set applicationIds = subscriptions.stream().map(SubscriptionEntity::getApplication).collect(Collectors.toSet());
        if (applicationIds.isEmpty()) {
            return Collections.emptyList();
        }
        ApplicationQuery applicationQuery = new ApplicationQuery();
        if (exclude != null && !exclude.isEmpty()) {
            applicationQuery.setExcludeFilters(exclude);
        }
        applicationQuery.setIds(applicationIds);
        if (query != null && !query.isEmpty()) {
            applicationQuery.setName(query);
        }
        if ((subscribersApplicationPage = this.applicationService.search(executionContext, applicationQuery, (Sortable)(sortable = new SortableImpl("name", true)), pageable.toPageable())) == null) {
            return Collections.emptyList();
        }
        return subscribersApplicationPage.getContent();
    }
}

