/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Tag(name="API Events")
public class ApiEventResource
extends AbstractResource {
    @Inject
    private EventService eventService;
    @PathParam(value="api")
    @Parameter(name="api", hidden=true)
    private String api;
    @PathParam(value="eventId")
    @Parameter(name="eventId")
    private String eventId;

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get an API event with its id", description="User must have the READ API_EVENT permission to use this service")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="API event", content={@Content(mediaType="application/json", schema=@Schema(implementation=EventEntity.class))}), @ApiResponse(responseCode="500", description="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.API_EVENT, acls={RolePermissionAction.READ})})
    public Response getEvent() {
        return Response.ok((Object)this.eventService.findById(GraviteeContext.getExecutionContext(), this.eventId)).build();
    }
}

