/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.param.LogsParam;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.analytics.query.LogQuery;
import io.gravitee.rest.api.model.log.ApiRequest;
import io.gravitee.rest.api.model.log.SearchLogResponse;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.LogsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Api(tags={"Platform Logs"})
public class PlatformLogsResource
extends AbstractResource {
    @Inject
    private LogsService logsService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get platform logs", notes="User must have the MANAGEMENT_PLATFORM[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Platform logs", response=SearchLogResponse.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public SearchLogResponse getPlatformLogs(@BeanParam LogsParam param) {
        param.validate();
        LogQuery logQuery = new LogQuery();
        logQuery.setQuery(param.getQuery());
        logQuery.setPage(param.getPage());
        logQuery.setSize(param.getSize());
        logQuery.setFrom(param.getFrom());
        logQuery.setTo(param.getTo());
        logQuery.setField(param.getField());
        logQuery.setOrder(param.isOrder());
        return this.logsService.findPlatform(logQuery);
    }

    @GET
    @Path(value="/{log}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a specific log", notes="User must have the MANAGEMENT_PLATFORM[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Single log", response=ApiRequest.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public ApiRequest getPlatformLog(@PathParam(value="log") String logId, @QueryParam(value="timestamp") Long timestamp) {
        return this.logsService.findApiLog(logId, timestamp);
    }

    @GET
    @Path(value="export")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Export platform logs as CSV", notes="User must have the MANAGEMENT_PLATFORM[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Platform logs as CSV"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_PLATFORM, acls={RolePermissionAction.READ})})
    public Response exportPlatformLogsAsCSV(@BeanParam LogsParam param) {
        SearchLogResponse searchLogResponse = this.getPlatformLogs(param);
        return Response.ok((Object)this.logsService.exportAsCsv(searchLogResponse)).header("Content-Disposition", (Object)String.format("attachment;filename=logs-%s-%s.csv", "platform", System.currentTimeMillis())).build();
    }
}

