/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.MetadataEntity;
import io.gravitee.rest.api.model.NewMetadataEntity;
import io.gravitee.rest.api.model.UpdateMetadataEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.MetadataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Api(tags={"Metadata"})
public class MetadataResource
extends AbstractResource {
    @Inject
    private MetadataService metadataService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the list of platform metadata", notes="User must have the PORTAL_METADATA[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="List of platform metadata", response=MetadataEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_METADATA, acls={RolePermissionAction.READ})})
    public List<MetadataEntity> getMetadatas() {
        return this.metadataService.findAllDefault();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a platform metadata", notes="User must have the PORTAL_METADATA[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Metadata successfully created", response=MetadataEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_METADATA, acls={RolePermissionAction.CREATE})})
    public MetadataEntity createMetadata(@Valid @NotNull NewMetadataEntity metadata) {
        return this.metadataService.create(metadata);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a platform metadata", notes="User must have the PORTAL_METADATA[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated metadata", response=MetadataEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_METADATA, acls={RolePermissionAction.UPDATE})})
    public MetadataEntity updateMetadata(@Valid @NotNull UpdateMetadataEntity metadata) {
        return this.metadataService.update(metadata);
    }

    @Path(value="{metadata}")
    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete a platform metadata", notes="User must have the PORTAL_METADATA[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Metadata successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_METADATA, acls={RolePermissionAction.DELETE})})
    public void deleteMetadata(@PathParam(value="metadata") String metadata) {
        this.metadataService.delete(metadata);
    }
}

