/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.resource.EnvironmentResource;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api
public class EnvironmentsResource
extends AbstractResource {
    @Context
    private ResourceContext resourceContext;
    @Inject
    private EnvironmentService environmentService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List available environments for current user organization")
    public Collection<EnvironmentEntity> getEnvironments() {
        return this.environmentService.findByUser(this.getAuthenticatedUserOrNull());
    }

    @Path(value="{envId}")
    public EnvironmentResource getEnvironmentResource(@PathParam(value="envId") @ApiParam(name="envId", required=true, defaultValue="DEFAULT", value="The ID of the environment") String envId) {
        return (EnvironmentResource)this.resourceContext.getResource(EnvironmentResource.class);
    }
}

