/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.repository.management.model.DashboardReferenceType;
import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.DashboardEntity;
import io.gravitee.rest.api.model.NewDashboardEntity;
import io.gravitee.rest.api.model.UpdateDashboardEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.DashboardService;
import io.gravitee.rest.api.service.exceptions.ForbiddenAccessException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Api(tags={"Dashboards"})
public class DashboardsResource
extends AbstractResource {
    @Inject
    private DashboardService dashboardService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the list of platform dashboards")
    @ApiResponses(value={@ApiResponse(code=200, message="List of platform dashboards", response=DashboardEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    public List<DashboardEntity> getDashboards(@QueryParam(value="reference_type") DashboardReferenceType referenceType) {
        if (!(this.hasPermission(RolePermission.ENVIRONMENT_DASHBOARD, RolePermissionAction.READ) || this.hasPermission(RolePermission.ENVIRONMENT_API, RolePermissionAction.READ) || this.canReadAPIConfiguration())) {
            throw new ForbiddenAccessException();
        }
        if (referenceType == null) {
            return this.dashboardService.findAll();
        }
        return this.dashboardService.findByReferenceType(referenceType);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a platform dashboard", notes="User must have the MANAGEMENT_DASHBOARD[CREATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=201, message="Dashboard successfully created", response=DashboardEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DASHBOARD, acls={RolePermissionAction.CREATE})})
    public DashboardEntity createDashboard(@Valid @NotNull NewDashboardEntity dashboard) {
        return this.dashboardService.create(dashboard);
    }

    @GET
    @Path(value="{dashboardId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve a platform dashboard", notes="User must have the MANAGEMENT_DASHBOARD[READ] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Platform dashboard", response=DashboardEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DASHBOARD, acls={RolePermissionAction.READ})})
    public DashboardEntity getDashboard(@PathParam(value="dashboardId") String dashboardId) {
        return this.dashboardService.findById(dashboardId);
    }

    @Path(value="{dashboardId}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a platform dashboard", notes="User must have the MANAGEMENT_DASHBOARD[UPDATE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Updated dashboard", response=DashboardEntity.class), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DASHBOARD, acls={RolePermissionAction.UPDATE})})
    public DashboardEntity updateDashboard(@PathParam(value="dashboardId") String dashboardId, @Valid @NotNull UpdateDashboardEntity dashboard) {
        dashboard.setId(dashboardId);
        return this.dashboardService.update(dashboard);
    }

    @Path(value="{dashboardId}")
    @DELETE
    @Consumes(value={"application/json"})
    @ApiOperation(value="Delete a platform dashboard", notes="User must have the MANAGEMENT_DASHBOARD[DELETE] permission to use this service")
    @ApiResponses(value={@ApiResponse(code=204, message="Dashboard successfully deleted"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.ENVIRONMENT_DASHBOARD, acls={RolePermissionAction.DELETE})})
    public void deleteDashboard(@PathParam(value="dashboardId") String dashboardId) {
        this.dashboardService.delete(dashboardId);
    }
}

