/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.management.rest.resource;

import io.gravitee.rest.api.management.rest.resource.AbstractResource;
import io.gravitee.rest.api.management.rest.security.Permission;
import io.gravitee.rest.api.management.rest.security.Permissions;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;

@Api(tags={"Application Subscriptions"})
public class ApplicationSubscribedResource
extends AbstractResource {
    @Inject
    private SubscriptionService subscriptionService;
    @Inject
    private ApiService apiService;
    @Context
    private ResourceContext resourceContext;
    @PathParam(value="application")
    @ApiParam(name="application", hidden=true)
    private String application;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List APIs subscribed by the application", notes="User must have the APPLICATION_SUBSCRIPTION permission to use this service")
    @ApiResponses(value={@ApiResponse(code=200, message="Paged result of subscribed APIs", response=ApplicationEntity.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error")})
    @Permissions(value={@Permission(value=RolePermission.APPLICATION_SUBSCRIPTION, acls={RolePermissionAction.READ})})
    public Collection<SubscribedApi> getApiSubscribed() {
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setApplication(this.application);
        Collection subscriptions = this.subscriptionService.search(subscriptionQuery);
        return subscriptions.stream().map(SubscriptionEntity::getApi).distinct().map(api -> this.apiService.findById(api)).map(apiEntity -> new SubscribedApi(apiEntity.getId(), apiEntity.getName())).sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName())).collect(Collectors.toList());
    }

    private static class SubscribedApi {
        private final String id;
        private final String name;

        SubscribedApi(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

